"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntryItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionAutocomplete = require("@kbn/securitysolution-autocomplete");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlexItemWithLabel = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding-top: 20px;
  text-align: center;
`;
const FlexItemWithoutLabel = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  text-align: center;
`;
const EntryItem = ({
  entry,
  indexPattern,
  threatIndexPatterns,
  showLabel,
  onChange
}) => {
  const handleFieldChange = (0, _react.useCallback)(([newField]) => {
    const {
      updatedEntry,
      index
    } = (0, _helpers.getEntryOnFieldChange)(entry, newField);
    onChange(updatedEntry, index);
  }, [onChange, entry]);
  const handleThreatFieldChange = (0, _react.useCallback)(([newField]) => {
    const {
      updatedEntry,
      index
    } = (0, _helpers.getEntryOnThreatFieldChange)(entry, newField);
    onChange(updatedEntry, index);
  }, [onChange, entry]);
  const renderFieldInput = (0, _react.useMemo)(() => {
    const comboBox = /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.FieldComponent, {
      placeholder: i18n.FIELD_PLACEHOLDER,
      indexPattern: indexPattern,
      selectedField: entry.field,
      isClearable: false,
      isLoading: false,
      isDisabled: indexPattern == null,
      onChange: handleFieldChange,
      "data-test-subj": "entryField",
      fieldInputWidth: 360
    });
    if (showLabel) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: i18n.FIELD,
        "data-test-subj": "entryItemFieldInputFormRow"
      }, comboBox);
    } else {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: '',
        "data-test-subj": "entryItemFieldInputFormRow"
      }, comboBox);
    }
  }, [handleFieldChange, indexPattern, entry, showLabel]);
  const renderThreatFieldInput = (0, _react.useMemo)(() => {
    const comboBox = /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.FieldComponent, {
      placeholder: i18n.FIELD_PLACEHOLDER,
      indexPattern: threatIndexPatterns,
      selectedField: entry.value,
      isClearable: false,
      isLoading: false,
      isDisabled: threatIndexPatterns == null,
      onChange: handleThreatFieldChange,
      "data-test-subj": "threatEntryField",
      fieldInputWidth: 360
    });
    if (showLabel) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: i18n.THREAT_FIELD,
        "data-test-subj": "threatFieldInputFormRow"
      }, comboBox);
    } else {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: '',
        "data-test-subj": "threatFieldInputFormRow"
      }, comboBox);
    }
  }, [handleThreatFieldChange, threatIndexPatterns, entry, showLabel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "spaceAround",
    "data-test-subj": "itemEntryContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderFieldInput), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround",
    alignItems: "center"
  }, showLabel ? /*#__PURE__*/_react.default.createElement(FlexItemWithLabel, {
    grow: true
  }, i18n.MATCHES) : /*#__PURE__*/_react.default.createElement(FlexItemWithoutLabel, {
    grow: true
  }, i18n.MATCHES))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderThreatFieldInput));
};
exports.EntryItem = EntryItem;
EntryItem.displayName = 'EntryItem';