"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toStrSelector = exports.startSelector = exports.queriesSelector = exports.policySelector = exports.kqlQuerySelector = exports.kindSelector = exports.isLoadingSelector = exports.getTimerange = exports.getQueries = exports.getPolicy = exports.getGlobalQueries = exports.fromStrSelector = exports.endSelector = exports.durationSelector = void 0;
var _lodash = require("lodash");
var _reselect = require("reselect");
var _constants = require("../../store/inputs/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPolicy = inputState => inputState.policy;
exports.getPolicy = getPolicy;
const getTimerange = inputState => inputState.timerange;
exports.getTimerange = getTimerange;
const getQueries = inputState => inputState.queries;
exports.getQueries = getQueries;
const getGlobalQueries = (state, id) => {
  const inputsRange = state.inputs[id];
  return !(0, _lodash.isEmpty)(inputsRange.linkTo) ? inputsRange.linkTo.reduce((acc, linkToId) => {
    if (linkToId === _constants.InputsModelId.socTrends) {
      return acc;
    }
    const linkToIdInputsRange = state.inputs[linkToId];
    return [...acc, ...linkToIdInputsRange.queries];
  }, inputsRange.queries) : inputsRange.queries;
};
exports.getGlobalQueries = getGlobalQueries;
const policySelector = () => (0, _reselect.createSelector)(getPolicy, policy => policy.kind);
exports.policySelector = policySelector;
const durationSelector = () => (0, _reselect.createSelector)(getPolicy, policy => policy.duration);
exports.durationSelector = durationSelector;
const kindSelector = () => (0, _reselect.createSelector)(getTimerange, timerange => timerange.kind);
exports.kindSelector = kindSelector;
const startSelector = () => (0, _reselect.createSelector)(getTimerange, timerange => timerange.from);
exports.startSelector = startSelector;
const endSelector = () => (0, _reselect.createSelector)(getTimerange, timerange => timerange.to);
exports.endSelector = endSelector;
const fromStrSelector = () => (0, _reselect.createSelector)(getTimerange, timerange => timerange.fromStr);
exports.fromStrSelector = fromStrSelector;
const toStrSelector = () => (0, _reselect.createSelector)(getTimerange, timerange => timerange.toStr);
exports.toStrSelector = toStrSelector;
const isLoadingSelector = () => (0, _reselect.createSelector)(getQueries, queries => queries.some(i => i.loading === true));
exports.isLoadingSelector = isLoadingSelector;
const queriesSelector = () => (0, _reselect.createSelector)(getGlobalQueries, queries => queries.filter(q => q.id !== 'kql'));
exports.queriesSelector = queriesSelector;
const kqlQuerySelector = () => (0, _reselect.createSelector)(getQueries, queries => queries.find(q => q.id === 'kql'));
exports.kqlQuerySelector = kqlQuerySelector;