"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Subtitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Wrapper = _styledComponents.default.div`
  ${({
  theme
}) => (0, _styledComponents.css)`
    .siemSubtitle__item {
      color: ${theme.eui.euiTextSubduedColor};
      font-size: ${theme.eui.euiFontSizeXS};
      line-height: ${theme.eui.euiLineHeight};

      @media only screen and (min-width: ${theme.eui.euiBreakpoints.s}) {
        display: inline-block;
        margin-right: ${theme.eui.euiSize};

        &:last-child {
          margin-right: 0;
        }
      }
    }
  `}
`;
Wrapper.displayName = 'Wrapper';
const SubtitleItem = /*#__PURE__*/_react.default.memo(({
  children,
  dataTestSubj = 'header-panel-subtitle'
}) => {
  if (typeof children === 'string') {
    return /*#__PURE__*/_react.default.createElement("p", {
      className: "siemSubtitle__item siemSubtitle__item--text",
      "data-test-subj": dataTestSubj
    }, children);
  } else {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "siemSubtitle__item siemSubtitle__item--node",
      "data-test-subj": dataTestSubj
    }, children);
  }
});
SubtitleItem.displayName = 'SubtitleItem';
const Subtitle = /*#__PURE__*/_react.default.memo(({
  items
}) => {
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    className: "siemSubtitle"
  }, Array.isArray(items) ? items.map((item, i) => /*#__PURE__*/_react.default.createElement(SubtitleItem, {
    key: i
  }, item)) : /*#__PURE__*/_react.default.createElement(SubtitleItem, null, items));
});
exports.Subtitle = Subtitle;
Subtitle.displayName = 'Subtitle';