"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoMatchDataMessage = exports.MissingPatternsMessage = exports.DeprecatedMessage = exports.CurrentPatternsMessage = exports.BadCurrentPatternsMessage = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../common/types");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CurrentPatternsMessage = ({
  activePatterns,
  deadPatterns,
  selectedPatterns,
  timelineType
}) => {
  const tooltip = (0, _react.useMemo)(() => deadPatterns.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(NoMatchDataMessage, {
      activePatterns: activePatterns,
      selectedPatterns: selectedPatterns,
      timelineType: timelineType
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "questionInCircle",
    title: i18n.INACTIVE_PATTERNS
  })) : null, [activePatterns, deadPatterns.length, selectedPatterns, timelineType]);
  if (timelineType === _types.TimelineType.template) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      "data-test-subj": "sourcerer-current-patterns-message",
      id: "xpack.securitySolution.indexPatterns.timelineTemplate.currentPatterns",
      defaultMessage: "The active index patterns in this timeline template are{tooltip}: {callout}",
      values: {
        tooltip,
        callout: /*#__PURE__*/_react.default.createElement(_helpers.Blockquote, null, activePatterns.join(', '))
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "sourcerer-current-patterns-message",
    id: "xpack.securitySolution.indexPatterns.timeline.currentPatterns",
    defaultMessage: "The active index patterns in this timeline are{tooltip}: {callout}",
    values: {
      tooltip,
      callout: /*#__PURE__*/_react.default.createElement(_helpers.Blockquote, null, activePatterns.join(', '))
    }
  });
};
exports.CurrentPatternsMessage = CurrentPatternsMessage;
const NoMatchDataMessage = ({
  activePatterns,
  selectedPatterns,
  timelineType
}) => {
  const aliases = (0, _react.useMemo)(() => selectedPatterns.filter(p => !activePatterns.includes(p)).join(', '), [activePatterns, selectedPatterns]);
  if (timelineType === _types.TimelineType.template) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.indexPatterns.timelineTemplate.noMatchData",
      defaultMessage: "The following index patterns are saved to this timeline template but do not match any data streams, indices, or index aliases: {aliases}",
      values: {
        aliases
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.timeline.noMatchData",
    defaultMessage: "The following index patterns are saved to this timeline but do not match any data streams, indices, or index aliases: {aliases}",
    values: {
      aliases
    }
  });
};
exports.NoMatchDataMessage = NoMatchDataMessage;
const BadCurrentPatternsMessage = ({
  timelineType,
  selectedPatterns
}) => {
  const callout = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_helpers.Blockquote, null, selectedPatterns.join(', ')), [selectedPatterns]);
  if (timelineType === _types.TimelineType.template) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.indexPatterns.timelineTemplate.currentPatternsBad",
      defaultMessage: "The current index patterns in this timeline template are: {callout}",
      values: {
        callout
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.timeline.currentPatternsBad",
    defaultMessage: "The current index patterns in this timeline are: {callout}",
    values: {
      callout
    }
  });
};
exports.BadCurrentPatternsMessage = BadCurrentPatternsMessage;
const DeprecatedMessage = ({
  onReset,
  timelineType
}) => {
  if (timelineType === _types.TimelineType.template) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      "data-test-subj": "sourcerer-deprecated-message",
      id: "xpack.securitySolution.indexPatterns.timelineTemplate.toggleToNewSourcerer",
      defaultMessage: "We have preserved your timeline template by creating a temporary data view. If you'd like to modify your data, we can recreate your temporary data view with the new data view selector. You can also manually select a data view {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: onReset
        }, i18n.TOGGLE_TO_NEW_SOURCERER)
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "sourcerer-deprecated-message",
    id: "xpack.securitySolution.indexPatterns.timeline.toggleToNewSourcerer",
    defaultMessage: "We have preserved your timeline by creating a temporary data view. If you'd like to modify your data, we can recreate your temporary data view with the new data view selector. You can also manually select a data view {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onReset
      }, i18n.TOGGLE_TO_NEW_SOURCERER)
    }
  });
};
exports.DeprecatedMessage = DeprecatedMessage;
const MissingPatternsMessage = ({
  onReset,
  timelineType
}) => {
  if (timelineType === _types.TimelineType.template) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      "data-test-subj": "sourcerer-missing-patterns-message",
      id: "xpack.securitySolution.indexPatterns.missingPatterns.timelineTemplate.description",
      defaultMessage: "We have preserved your timeline template by creating a temporary data view. If you'd like to modify your data, we can add the missing index patterns to the Security Data View. You can also manually select a data view {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: onReset
        }, i18n.TOGGLE_TO_NEW_SOURCERER)
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "sourcerer-missing-patterns-message",
    id: "xpack.securitySolution.indexPatterns.missingPatterns.timeline.description",
    defaultMessage: "We have preserved your timeline by creating a temporary data view. If you'd like to modify your data, we can add the missing index patterns to the Security Data View. You can also manually select a data view {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onReset
      }, i18n.TOGGLE_TO_NEW_SOURCERER)
    }
  });
};
exports.MissingPatternsMessage = MissingPatternsMessage;