"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePickIndexPatterns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _helpers = require("../../store/sourcerer/helpers");
var _sourcerer = require("../../store/sourcerer");
var _helpers2 = require("./helpers");
var _model = require("../../store/sourcerer/model");
var _sourcerer2 = require("../../../../common/utils/sourcerer");
var _kibana = require("../../lib/kibana");
var _get_sourcerer_data_view = require("../../containers/sourcerer/get_sourcerer_data_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const patternListToOptions = (patternList, selectablePatterns) => (0, _sourcerer2.sortWithExcludesAtEnd)(patternList).map(s => ({
  label: s,
  value: s,
  ...(selectablePatterns != null ? {
    disabled: !selectablePatterns.includes(s)
  } : {})
}));
const usePickIndexPatterns = ({
  dataViewId,
  defaultDataViewId,
  isOnlyDetectionAlerts,
  kibanaDataViews,
  missingPatterns,
  scopeId,
  selectedDataViewId,
  selectedPatterns,
  signalIndexName
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    data: {
      dataViews
    }
  } = (0, _kibana.useKibana)().services;
  const isHookAlive = (0, _react.useRef)(true);
  const [loadingIndexPatterns, setLoadingIndexPatterns] = (0, _react.useState)(false);
  const alertsOptions = (0, _react.useMemo)(() => signalIndexName ? patternListToOptions([signalIndexName]) : [], [signalIndexName]);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)(isOnlyDetectionAlerts ? alertsOptions : patternListToOptions(selectedPatterns));
  const [isModified, setIsModified] = (0, _react.useState)(dataViewId == null ? 'deprecated' : missingPatterns.length > 0 ? 'missingPatterns' : '');
  const {
    allPatterns,
    selectablePatterns
  } = (0, _react.useMemo)(() => {
    if (isOnlyDetectionAlerts && signalIndexName) {
      return {
        allPatterns: [signalIndexName],
        selectablePatterns: [signalIndexName]
      };
    }
    const theDataView = kibanaDataViews.find(dataView => dataView.id === dataViewId);
    if (theDataView == null) {
      return {
        allPatterns: [],
        selectablePatterns: []
      };
    }
    const titleAsList = [...new Set(theDataView.title.split(','))];
    return scopeId === _sourcerer.sourcererModel.SourcererScopeName.default ? {
      allPatterns: (0, _helpers2.getPatternListWithoutSignals)(titleAsList, signalIndexName),
      selectablePatterns: (0, _helpers2.getPatternListWithoutSignals)(theDataView.patternList, signalIndexName)
    } : {
      allPatterns: titleAsList,
      selectablePatterns: theDataView.patternList
    };
  }, [dataViewId, isOnlyDetectionAlerts, kibanaDataViews, scopeId, signalIndexName]);
  const allOptions = (0, _react.useMemo)(() => patternListToOptions(allPatterns, selectablePatterns), [allPatterns, selectablePatterns]);
  const getDefaultSelectedOptionsByDataView = (0, _react.useCallback)((id, isAlerts = false) => scopeId === _model.SourcererScopeName.detections || isAlerts ? alertsOptions : patternListToOptions((0, _helpers.getScopePatternListSelection)(kibanaDataViews.find(dataView => dataView.id === id), scopeId, signalIndexName, id === defaultDataViewId)), [alertsOptions, kibanaDataViews, scopeId, signalIndexName, defaultDataViewId]);
  const defaultSelectedPatternsAsOptions = (0, _react.useMemo)(() => dataViewId != null ? getDefaultSelectedOptionsByDataView(dataViewId) : [], [dataViewId, getDefaultSelectedOptionsByDataView]);
  const onSetIsModified = (0, _react.useCallback)((patterns, id) => {
    if (id == null) {
      return setIsModified('deprecated');
    }
    if (missingPatterns.length > 0) {
      return setIsModified('missingPatterns');
    }
    if (isOnlyDetectionAlerts) {
      return setIsModified('alerts');
    }
    const isPatternsModified = defaultSelectedPatternsAsOptions.length !== patterns.length || !defaultSelectedPatternsAsOptions.every(option => patterns.find(pattern => option.value === pattern));
    return setIsModified(isPatternsModified ? 'modified' : '');
  }, [defaultSelectedPatternsAsOptions, isOnlyDetectionAlerts, missingPatterns.length]);
  (0, _react.useEffect)(() => {
    setSelectedOptions(scopeId === _model.SourcererScopeName.detections ? alertsOptions : patternListToOptions(selectedPatterns));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedPatterns, scopeId]);
  // when scope updates, check modified to set/remove alerts label
  (0, _react.useEffect)(() => {
    onSetIsModified(selectedPatterns.map(pattern => pattern), selectedDataViewId);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isOnlyDetectionAlerts, selectedDataViewId, missingPatterns, scopeId, selectedPatterns]);
  const onChangeCombo = (0, _react.useCallback)(newSelectedOptions => {
    setSelectedOptions(newSelectedOptions);
  }, []);
  const renderOption = (0, _react.useCallback)(({
    value
  }) => /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "sourcerer-combo-option"
  }, value), []);
  const setIndexPatternsByDataView = (0, _react.useCallback)(async (newSelectedDataViewId, isAlerts) => {
    if (kibanaDataViews.some(kdv => kdv.id === newSelectedDataViewId && kdv.indexFields.length === 0)) {
      try {
        setLoadingIndexPatterns(true);
        setSelectedOptions([]);
        const dataView = await (0, _get_sourcerer_data_view.getSourcererDataView)(newSelectedDataViewId, dataViews);
        if (isHookAlive.current) {
          dispatch(_sourcerer.sourcererActions.setDataView(dataView));
          setSelectedOptions(isOnlyDetectionAlerts ? alertsOptions : patternListToOptions(dataView.patternList));
        }
      } catch (err) {
        // Nothing to do
      }
      setLoadingIndexPatterns(false);
    } else {
      setSelectedOptions(getDefaultSelectedOptionsByDataView(newSelectedDataViewId, isAlerts));
    }
  }, [alertsOptions, dispatch, getDefaultSelectedOptionsByDataView, isOnlyDetectionAlerts, kibanaDataViews, dataViews]);
  const dataViewSelectOptions = (0, _react.useMemo)(() => dataViewId != null ? (0, _helpers2.getDataViewSelectOptions)({
    dataViewId,
    defaultDataViewId,
    isModified: isModified === 'modified',
    isOnlyDetectionAlerts,
    kibanaDataViews
  }) : [], [dataViewId, defaultDataViewId, isModified, isOnlyDetectionAlerts, kibanaDataViews]);
  (0, _react.useEffect)(() => {
    isHookAlive.current = true;
    return () => {
      isHookAlive.current = false;
    };
  }, []);
  const handleOutsideClick = (0, _react.useCallback)(() => {
    setSelectedOptions(patternListToOptions(selectedPatterns));
  }, [selectedPatterns]);
  return {
    allOptions,
    dataViewSelectOptions,
    loadingIndexPatterns,
    handleOutsideClick,
    isModified,
    onChangeCombo,
    renderOption,
    selectedOptions,
    setIndexPatternsByDataView
  };
};
exports.usePickIndexPatterns = usePickIndexPatterns;