"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultSessionsFilter = exports.TEST_ID = exports.SessionsView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/session-view-plugin/public");
var _reactRedux = require("react-redux");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_add_bulk_to_timeline = require("../../../detections/components/alerts_table/timeline_actions/use_add_bulk_to_timeline");
var _events_viewer = require("../events_viewer");
var _default_headers = require("./default_headers");
var _renderers = require("../../../timelines/components/timeline/body/renderers");
var _default_cell_renderer = require("../../../timelines/components/timeline/cell_rendering/default_cell_renderer");
var i18n = _interopRequireWildcard(require("./translations"));
var _model = require("../../store/sourcerer/model");
var _control_columns = require("../../../timelines/components/timeline/body/control_columns");
var _use_license = require("../../hooks/use_license");
var _default_model = require("../events_viewer/default_model");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _constants = require("../../../timelines/components/timeline/body/constants");
var _cell_actions = require("../cell_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TEST_ID = 'security_solution:sessions_viewer:sessions_view';
exports.TEST_ID = TEST_ID;
const defaultSessionsFilter = {
  query: {
    bool: {
      filter: [{
        bool: {
          // show sessions table results by filtering events where event.action is fork, exec, or end
          should: [{
            term: {
              [_ruleDataUtils.EVENT_ACTION]: _public.EventAction.exec
            }
          }, {
            term: {
              [_ruleDataUtils.EVENT_ACTION]: _public.EventAction.fork
            }
          }, {
            term: {
              [_ruleDataUtils.EVENT_ACTION]: _public.EventAction.end
            }
          }]
        }
      }, {
        bool: {
          filter: {
            exists: {
              field: _public.ENTRY_SESSION_ENTITY_ID_PROPERTY // to exclude any records which have no entry_leader.entity_id
            }
          }
        }
      }]
    }
  },

  meta: {
    alias: null,
    disabled: false,
    key: _public.ENTRY_SESSION_ENTITY_ID_PROPERTY,
    negate: false,
    params: {},
    type: 'string'
  }
};
exports.defaultSessionsFilter = defaultSessionsFilter;
const SessionsViewComponent = ({
  tableId,
  endDate,
  entityType = 'sessions',
  pageFilters,
  startDate,
  filterQuery,
  columns = _default_headers.sessionsHeaders,
  defaultColumns = _default_headers.sessionsHeaders
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const tGridEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('tGridEnabled');
  const parsedFilterQuery = (0, _react.useMemo)(() => {
    if (filterQuery && filterQuery !== '') {
      return JSON.parse(filterQuery);
    }
    return {};
  }, [filterQuery]);
  const sessionsFilter = (0, _react.useMemo)(() => [{
    ...defaultSessionsFilter,
    query: {
      ...defaultSessionsFilter.query,
      bool: {
        ...defaultSessionsFilter.query.bool,
        filter: defaultSessionsFilter.query.bool.filter.concat(parsedFilterQuery)
      }
    }
  }, ...pageFilters], [pageFilters, parsedFilterQuery]);
  (0, _react.useEffect)(() => {
    dispatch(_securitysolutionDataTable.dataTableActions.initializeDataTableSettings({
      id: tableId,
      title: i18n.SESSIONS_TITLE,
      defaultColumns: _default_model.eventsDefaultModel.columns.map(c => !tGridEnabled && c.initialWidth == null ? {
        ...c,
        initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
      } : c),
      showCheckboxes: true,
      selectAll: true
    }));
  }, [dispatch, tGridEnabled, tableId]);
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const ACTION_BUTTON_COUNT = isEnterprisePlus || tableId === _securitysolutionDataTable.TableId.kubernetesPageSessions ? 5 : 4;
  const leadingControlColumns = (0, _react.useMemo)(() => (0, _control_columns.getDefaultControlColumn)(ACTION_BUTTON_COUNT), [ACTION_BUTTON_COUNT]);
  const addBulkToTimelineAction = (0, _use_add_bulk_to_timeline.useAddBulkToTimelineAction)({
    localFilters: sessionsFilter,
    tableId,
    from: startDate,
    to: endDate,
    scopeId: _model.SourcererScopeName.default
  });
  const bulkActions = (0, _react.useMemo)(() => {
    return {
      alertStatusActions: false,
      customBulkActions: [addBulkToTimelineAction]
    };
  }, [addBulkToTimelineAction]);
  const unit = c => c > 1 ? i18n.TOTAL_COUNT_OF_SESSIONS : i18n.SINGLE_COUNT_OF_SESSIONS;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_events_viewer.StatefulEventsViewer, {
    cellActionsTriggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
    pageFilters: sessionsFilter,
    defaultModel: (0, _default_headers.getSessionsDefaultModel)(columns, defaultColumns),
    end: endDate,
    bulkActions: bulkActions,
    entityType: entityType,
    tableId: tableId,
    leadingControlColumns: leadingControlColumns,
    renderCellValue: _default_cell_renderer.DefaultCellRenderer,
    rowRenderers: _renderers.defaultRowRenderers,
    sourcererScope: _model.SourcererScopeName.default,
    start: startDate,
    unit: unit
  }));
};
SessionsViewComponent.displayName = 'SessionsViewComponent';
const SessionsView = /*#__PURE__*/_react.default.memo(SessionsViewComponent);
exports.SessionsView = SessionsView;