"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleName = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const appendSearch = search => (0, _lodash.isEmpty)(search) ? '' : `${search !== null && search !== void 0 && search.startsWith('?') ? search : `?${search}`}`;
const RuleNameComponents = ({
  name,
  id,
  appId
}) => {
  const {
    navigateToApp,
    getUrlForApp
  } = (0, _public.useKibana)().services.application;
  const hrefRuleDetails = (0, _react.useMemo)(() => getUrlForApp(appId, {
    deepLinkId: 'rules',
    path: `/id/${id}${appendSearch(window.location.search)}`
  }), [getUrlForApp, id, appId]);
  const goToRuleDetails = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(appId, {
      deepLinkId: 'rules',
      path: `/id/${id}${appendSearch(window.location.search)}`
    });
  }, [navigateToApp, id, appId]);
  return (
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiLink, {
      href: hrefRuleDetails,
      onClick: goToRuleDetails
    }, name)
  );
};
const RuleName = /*#__PURE__*/_react.default.memo(RuleNameComponents);
exports.RuleName = RuleName;