"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/unified-search-plugin/public");
var _public3 = require("@kbn/kibana-utils-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryBar = /*#__PURE__*/(0, _react.memo)(({
  dateRangeFrom,
  dateRangeTo,
  hideSavedQuery = false,
  indexPattern,
  isLoading = false,
  isRefreshPaused,
  filterQuery,
  filterManager,
  filters,
  onChangedQuery,
  onSubmitQuery,
  refreshInterval,
  savedQuery,
  onSavedQuery,
  dataTestSubj,
  displayStyle,
  isDisabled
}) => {
  const onQuerySubmit = (0, _react.useCallback)(payload => {
    if (payload.query != null && !(0, _fastDeepEqual.default)(payload.query, filterQuery)) {
      onSubmitQuery(payload.query);
    }
  }, [filterQuery, onSubmitQuery]);
  const onQueryChange = (0, _react.useCallback)(payload => {
    if (onChangedQuery && payload.query != null && !(0, _fastDeepEqual.default)(payload.query, filterQuery)) {
      onChangedQuery(payload.query);
    }
  }, [filterQuery, onChangedQuery]);
  const onSavedQueryUpdated = (0, _react.useCallback)(savedQueryUpdated => {
    const {
      query: newQuery,
      filters: newFilters,
      timefilter
    } = savedQueryUpdated.attributes;
    onSubmitQuery(newQuery, timefilter);
    filterManager.setFilters(newFilters || []);
    onSavedQuery(savedQueryUpdated);
  }, [filterManager, onSubmitQuery, onSavedQuery]);
  const onClearSavedQuery = (0, _react.useCallback)(() => {
    if (savedQuery != null) {
      onSubmitQuery({
        query: '',
        language: savedQuery.attributes.query.language
      });
      filterManager.setFilters([]);
      onSavedQuery(undefined);
    }
  }, [filterManager, onSubmitQuery, onSavedQuery, savedQuery]);
  const onFiltersUpdated = (0, _react.useCallback)(newFilters => {
    filterManager.setFilters(newFilters);
  }, [filterManager]);
  const indexPatterns = (0, _react.useMemo)(() => [indexPattern], [indexPattern]);
  const timeHistory = (0, _react.useMemo)(() => new _public.TimeHistory(new _public3.Storage(localStorage)), []);
  return /*#__PURE__*/_react.default.createElement(_public2.SearchBar, {
    showSubmitButton: false,
    dateRangeFrom: dateRangeFrom,
    dateRangeTo: dateRangeTo,
    filters: filters,
    indexPatterns: indexPatterns,
    isLoading: isLoading,
    isRefreshPaused: isRefreshPaused,
    query: filterQuery,
    onClearSavedQuery: onClearSavedQuery,
    onFiltersUpdated: onFiltersUpdated,
    onQueryChange: onQueryChange,
    onQuerySubmit: onQuerySubmit,
    onSaved: onSavedQuery,
    onSavedQueryUpdated: onSavedQueryUpdated,
    refreshInterval: refreshInterval,
    showAutoRefreshOnly: false,
    showFilterBar: !hideSavedQuery,
    showDatePicker: false,
    showQueryInput: true,
    showSaveQuery: true,
    timeHistory: timeHistory,
    dataTestSubj: dataTestSubj,
    savedQuery: savedQuery,
    displayStyle: displayStyle,
    isDisabled: isDisabled
  });
});
exports.QueryBar = QueryBar;
QueryBar.displayName = 'QueryBar';