"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoNews = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
var _kibana = require("../../../lib/kibana");
var _links = require("../../links");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoNews = /*#__PURE__*/_react.default.memo(() => {
  var _capabilities$managem;
  const {
    getUrlForApp,
    navigateToApp,
    capabilities
  } = (0, _kibana.useKibana)().services.application;
  const canSeeAdvancedSettings = (_capabilities$managem = capabilities.management.kibana.settings) !== null && _capabilities$managem !== void 0 ? _capabilities$managem : false;
  const goToKibanaSettings = (0, _react.useCallback)(() => navigateToApp('management', {
    path: '/kibana/settings'
  }), [navigateToApp]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, canSeeAdvancedSettings ? i18n.NO_NEWS_MESSAGE_ADMIN : i18n.NO_NEWS_MESSAGE, canSeeAdvancedSettings && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    onClick: goToKibanaSettings,
    href: `${getUrlForApp('management', {
      path: '/kibana/settings'
    })}`
  }, i18n.ADVANCED_SETTINGS_LINK_TITLE), '.'));
});
exports.NoNews = NoNews;
NoNews.displayName = 'NoNews';