"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulNewsFeed = void 0;
var _react = _interopRequireWildcard(require("react"));
var _helpers = require("./helpers");
var _kibana = require("../../lib/kibana");
var _news_feed = require("./news_feed");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatefulNewsFeed = /*#__PURE__*/_react.default.memo(({
  enableNewsFeedSetting,
  newsFeedSetting
}) => {
  const kibanaNewsfeedEnabled = (0, _kibana.useKibana)().services.newsfeed;
  const [enableNewsFeed] = (0, _kibana.useUiSetting$)(enableNewsFeedSetting);
  const [newsFeedUrlSetting] = (0, _kibana.useUiSetting$)(newsFeedSetting);
  const [news, setNews] = (0, _react.useState)(null);

  // respect kibana's global newsfeed.enabled setting
  const newsfeedEnabled = kibanaNewsfeedEnabled && enableNewsFeed;
  const newsFeedUrl = (0, _helpers.getNewsFeedUrl)({
    newsFeedUrlSetting,
    getKibanaVersion: () => _kibana.KibanaServices.getKibanaVersion()
  });
  (0, _react.useEffect)(() => {
    let canceled = false;
    const fetchData = async () => {
      try {
        const apiResponse = await (0, _helpers.fetchNews)({
          newsFeedUrl
        });
        if (!canceled) {
          setNews((0, _helpers.getNewsItemsFromApiResponse)(apiResponse));
        }
      } catch {
        if (!canceled) {
          setNews([]);
        }
      }
    };
    if (newsfeedEnabled) {
      fetchData();
    }
    return () => {
      canceled = true;
    };
  }, [newsfeedEnabled, newsFeedUrl]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, newsfeedEnabled ? /*#__PURE__*/_react.default.createElement(_news_feed.NewsFeed, {
    news: news
  }) : null);
});
exports.StatefulNewsFeed = StatefulNewsFeed;
StatefulNewsFeed.displayName = 'StatefulNewsFeed';