"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrimaryNavigation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_navigation_items = require("./use_navigation_items");
var _helpers = require("../helpers");
var _security_side_nav = require("../security_side_nav");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const translatedNavTitle = _i18n.i18n.translate('xpack.securitySolution.navigation.mainLabel', {
  defaultMessage: 'Security'
});
const usePrimaryNavigation = ({
  navTabs,
  pageName
}) => {
  const isGroupedNavigationEnabled = (0, _helpers.useIsGroupedNavigationEnabled)();
  const mapLocationToTab = (0, _react.useCallback)(() => {
    var _navTabs$pageName$id, _navTabs$pageName;
    return (_navTabs$pageName$id = (_navTabs$pageName = navTabs[pageName]) === null || _navTabs$pageName === void 0 ? void 0 : _navTabs$pageName.id) !== null && _navTabs$pageName$id !== void 0 ? _navTabs$pageName$id : '';
  }, [pageName, navTabs]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(mapLocationToTab());
  (0, _react.useEffect)(() => {
    const currentTabSelected = mapLocationToTab();
    if (currentTabSelected !== selectedTabId) {
      setSelectedTabId(currentTabSelected);
    }

    // we do need navTabs in case the selectedTabId appears after initial load (ex. checking permissions for anomalies)
  }, [pageName, navTabs, mapLocationToTab, selectedTabId]);
  const navItems = (0, _use_navigation_items.usePrimaryNavigationItems)({
    navTabs,
    selectedTabId
  });
  return {
    canBeCollapsed: true,
    name: translatedNavTitle,
    icon: 'logoSecurity',
    ...(isGroupedNavigationEnabled ? {
      children: /*#__PURE__*/_react.default.createElement(_security_side_nav.SecuritySideNav, null),
      closeFlyoutButtonPosition: 'inside'
    } : {
      items: navItems
    })
  };
};
exports.usePrimaryNavigation = usePrimaryNavigation;