"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrimaryNavigationItems = void 0;
var _react = require("react");
var _home_navigations = require("../../../../app/home/home_navigations");
var _helpers = require("../helpers");
var _kibana_react = require("../../../lib/kibana/kibana_react");
var _kibana = require("../../../lib/kibana");
var _hooks = require("../../../lib/kibana/hooks");
var _types = require("../types");
var _constants = require("../../../../../common/constants");
var _use_experimental_features = require("../../../hooks/use_experimental_features");
var _global_query_string = require("../../../utils/global_query_string");
var _user_privileges = require("../../user_privileges");
var _telemetry = require("../../../lib/telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePrimaryNavigationItems = ({
  navTabs,
  selectedTabId
}) => {
  const {
    navigateTo,
    getAppUrl
  } = (0, _hooks.useNavigation)();
  const globalQueryString = (0, _global_query_string.useGlobalQueryString)();
  const getSideNav = (0, _react.useCallback)(tab => {
    const {
      id,
      name,
      disabled
    } = tab;
    const isSelected = selectedTabId === id;
    const urlSearch = (0, _helpers.getSearch)(tab.id, globalQueryString);
    const handleClick = ev => {
      ev.preventDefault();
      (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, `${_telemetry.TELEMETRY_EVENT.LEGACY_NAVIGATION}${id}`);
      navigateTo({
        deepLinkId: id,
        path: urlSearch
      });
    };
    const appHref = getAppUrl({
      deepLinkId: id,
      path: urlSearch
    });
    return {
      'data-href': appHref,
      'data-test-subj': `navigation-${id}`,
      disabled,
      href: appHref,
      id,
      isSelected,
      name,
      onClick: handleClick
    };
  }, [getAppUrl, navigateTo, selectedTabId, globalQueryString]);
  const navItemsToDisplay = usePrimaryNavigationItemsToDisplay(navTabs);
  return (0, _react.useMemo)(() => navItemsToDisplay.map(item => ({
    ...item,
    items: item.items.map(t => getSideNav(t))
  })), [getSideNav, navItemsToDisplay]);
};
exports.usePrimaryNavigationItems = usePrimaryNavigationItems;
function usePrimaryNavigationItemsToDisplay(navTabs) {
  const hasCasesReadPermissions = (0, _kibana.useGetUserCasesPermissions)().read;
  const {
    canReadActionsLogManagement,
    canReadHostIsolationExceptions
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const isPolicyListEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('policyListEnabled');
  const uiCapabilities = (0, _kibana_react.useKibana)().services.application.capabilities;
  return (0, _react.useMemo)(() => uiCapabilities.siem.show ? [{
    id: 'main',
    name: '',
    items: [navTabs[_constants.SecurityPageName.landing]]
  }, {
    ..._home_navigations.securityNavGroup[_types.SecurityNavGroupKey.dashboards],
    items: [navTabs[_constants.SecurityPageName.overview], navTabs[_constants.SecurityPageName.detectionAndResponse], navTabs[_constants.SecurityPageName.cloudSecurityPostureDashboard], navTabs[_constants.SecurityPageName.entityAnalytics], navTabs[_constants.SecurityPageName.dataQuality], ...(navTabs[_constants.SecurityPageName.kubernetes] != null ? [navTabs[_constants.SecurityPageName.kubernetes]] : [])]
  }, {
    ..._home_navigations.securityNavGroup[_types.SecurityNavGroupKey.detect],
    items: [navTabs[_constants.SecurityPageName.alerts], navTabs[_constants.SecurityPageName.rules], navTabs[_constants.SecurityPageName.exceptions]]
  }, {
    ..._home_navigations.securityNavGroup[_types.SecurityNavGroupKey.findings],
    items: [navTabs[_constants.SecurityPageName.cloudSecurityPostureFindings]]
  }, {
    ..._home_navigations.securityNavGroup[_types.SecurityNavGroupKey.explore],
    items: [navTabs[_constants.SecurityPageName.hosts], navTabs[_constants.SecurityPageName.network], ...(navTabs[_constants.SecurityPageName.users] != null ? [navTabs[_constants.SecurityPageName.users]] : [])]
  }, {
    ..._home_navigations.securityNavGroup[_types.SecurityNavGroupKey.intelligence],
    items: [navTabs[_constants.SecurityPageName.threatIntelligenceIndicators]]
  }, {
    ..._home_navigations.securityNavGroup[_types.SecurityNavGroupKey.investigate],
    items: hasCasesReadPermissions ? [navTabs[_constants.SecurityPageName.timelines], navTabs[_constants.SecurityPageName.case]] : [navTabs[_constants.SecurityPageName.timelines]]
  }, {
    ..._home_navigations.securityNavGroup[_types.SecurityNavGroupKey.manage],
    items: [
    // TODO: also hide other management pages based on authz privileges
    navTabs[_constants.SecurityPageName.endpoints], ...(isPolicyListEnabled ? [navTabs[_constants.SecurityPageName.policies]] : []), navTabs[_constants.SecurityPageName.trustedApps], navTabs[_constants.SecurityPageName.eventFilters], ...(canReadHostIsolationExceptions ? [navTabs[_constants.SecurityPageName.hostIsolationExceptions]] : []), navTabs[_constants.SecurityPageName.blocklist], ...(canReadActionsLogManagement ? [navTabs[_constants.SecurityPageName.responseActionsHistory]] : []), navTabs[_constants.SecurityPageName.cloudSecurityPostureBenchmarks]]
  }] : hasCasesReadPermissions ? [{
    ..._home_navigations.securityNavGroup[_types.SecurityNavGroupKey.investigate],
    items: [navTabs[_constants.SecurityPageName.case]]
  }] : [], [uiCapabilities.siem.show, navTabs, hasCasesReadPermissions, canReadHostIsolationExceptions, canReadActionsLogManagement, isPolicyListEnabled]);
}