"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecuritySolutionNavigation = void 0;
var _react = require("react");
var _fp = require("lodash/fp");
var _use_primary_navigation = require("./use_primary_navigation");
var _kibana = require("../../../lib/kibana");
var _breadcrumbs = require("../breadcrumbs");
var _use_route_spy = require("../../../utils/route/use_route_spy");
var _home_navigations = require("../../../../app/home/home_navigations");
var _use_experimental_features = require("../../../hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @description - This hook provides the structure necessary by the KibanaPageTemplate for rendering the primary security_solution side navigation.
 * TODO: Consolidate & re-use the logic in the hooks in this directory that are replicated from the tab_navigation to maintain breadcrumbs, telemetry, etc...
 */
const useSecuritySolutionNavigation = () => {
  const [routeProps] = (0, _use_route_spy.useRouteSpy)();
  const {
    chrome,
    application: {
      getUrlForApp,
      navigateToUrl
    }
  } = (0, _kibana.useKibana)().services;
  const disabledNavTabs = [...(!(0, _use_experimental_features.useIsExperimentalFeatureEnabled)('kubernetesEnabled') ? ['kubernetes'] : [])];
  const enabledNavTabs = (0, _fp.omit)(disabledNavTabs, _home_navigations.navTabs);
  const setBreadcrumbs = (0, _breadcrumbs.useSetBreadcrumbs)();
  (0, _react.useEffect)(() => {
    if (!routeProps.pathName && !routeProps.pageName) {
      return;
    }
    setBreadcrumbs({
      ...routeProps,
      navTabs: _home_navigations.navTabs
    }, chrome, navigateToUrl);
  }, [routeProps, chrome, getUrlForApp, navigateToUrl, enabledNavTabs, setBreadcrumbs]);
  return (0, _use_primary_navigation.usePrimaryNavigation)({
    navTabs: enabledNavTabs,
    pageName: routeProps.pageName
  });
};
exports.useSecuritySolutionNavigation = useSecuritySolutionNavigation;