"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetUrlStateQueryString = exports.useGetUrlSearch = void 0;
var _react = require("react");
var _global_query_string = require("../../utils/global_query_string");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetUrlSearch = pageName => {
  const globalQueryString = (0, _global_query_string.useGlobalQueryString)();
  const urlSearch = (0, _react.useMemo)(() => (0, _helpers.getSearch)(pageName, globalQueryString), [globalQueryString, pageName]);
  return urlSearch;
};
exports.useGetUrlSearch = useGetUrlSearch;
const useGetUrlStateQueryString = () => {
  const globalQueryString = (0, _global_query_string.useGlobalQueryString)();
  const getUrlStateQueryString = (0, _react.useCallback)(() => {
    return globalQueryString.length > 0 ? `?${globalQueryString}` : '';
  }, [globalQueryString]);
  return getUrlStateQueryString;
};
exports.useGetUrlStateQueryString = useGetUrlStateQueryString;