"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySideNav = exports.EUI_HEADER_HEIGHT = exports.BOTTOM_BAR_HEIGHT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitySolutionSideNav = require("@kbn/security-solution-side-nav");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _types = require("../../../../app/types");
var _links = require("../../../links");
var _use_route_spy = require("../../../utils/route/use_route_spy");
var _links2 = require("../../links");
var _nav_links = require("../nav_links");
var _use_show_timeline = require("../../../utils/timeline/use_show_timeline");
var _policy_hooks = require("../../../../management/pages/policy/view/policy_hooks");
var _telemetry = require("../../../lib/telemetry");
var _kibana = require("../../../lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EUI_HEADER_HEIGHT = '93px';
exports.EUI_HEADER_HEIGHT = EUI_HEADER_HEIGHT;
const BOTTOM_BAR_HEIGHT = '50px';
exports.BOTTOM_BAR_HEIGHT = BOTTOM_BAR_HEIGHT;
const isFooterNavItem = id => id === _types.SecurityPageName.landing || id === _types.SecurityPageName.administration;
const isGetStartedNavItem = id => id === _types.SecurityPageName.landing;

/**
 * Returns the formatted `items` and `footerItems` to be rendered in the navigation
 */
const useSolutionSideNavItems = () => {
  const navLinks = (0, _nav_links.useAppNavLinks)();
  const getSecuritySolutionLinkProps = (0, _links2.useGetSecuritySolutionLinkProps)(); // adds href and onClick props

  const sideNavItems = (0, _react.useMemo)(() => {
    const mainNavItems = [];
    const footerNavItems = [];
    navLinks.forEach(navLink => {
      if (navLink.disabled) {
        return;
      }
      let sideNavItem;
      if (isGetStartedNavItem(navLink.id)) {
        sideNavItem = {
          id: navLink.id,
          label: navLink.title.toUpperCase(),
          labelSize: 'xs',
          iconType: 'launch',
          ...getSecuritySolutionLinkProps({
            deepLinkId: navLink.id
          }),
          appendSeparator: true
        };
      } else {
        var _navLink$categories, _navLink$links;
        // generic links
        sideNavItem = {
          id: navLink.id,
          label: navLink.title,
          ...getSecuritySolutionLinkProps({
            deepLinkId: navLink.id
          }),
          ...(((_navLink$categories = navLink.categories) === null || _navLink$categories === void 0 ? void 0 : _navLink$categories.length) && {
            categories: navLink.categories
          }),
          ...(((_navLink$links = navLink.links) === null || _navLink$links === void 0 ? void 0 : _navLink$links.length) && {
            items: navLink.links.reduce((acc, current) => {
              if (!current.disabled) {
                acc.push({
                  id: current.id,
                  label: current.title,
                  description: current.description,
                  isBeta: current.isBeta,
                  betaOptions: current.betaOptions,
                  ...getSecuritySolutionLinkProps({
                    deepLinkId: current.id
                  })
                });
              }
              return acc;
            }, [])
          })
        };
      }
      if (isFooterNavItem(navLink.id)) {
        footerNavItems.push(sideNavItem);
      } else {
        mainNavItems.push(sideNavItem);
      }
    });
    return [mainNavItems, footerNavItems];
  }, [navLinks, getSecuritySolutionLinkProps]);
  return sideNavItems;
};
const useSelectedId = () => {
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const selectedId = (0, _react.useMemo)(() => {
    var _rootLinkInfo$id;
    const [rootLinkInfo] = (0, _links.getAncestorLinksInfo)(pageName);
    return (_rootLinkInfo$id = rootLinkInfo === null || rootLinkInfo === void 0 ? void 0 : rootLinkInfo.id) !== null && _rootLinkInfo$id !== void 0 ? _rootLinkInfo$id : '';
  }, [pageName]);
  return selectedId;
};
const usePanelTopOffset = () => {
  const {
    chrome: {
      hasHeaderBanner$
    }
  } = (0, _kibana.useKibana)().services;
  const hasHeaderBanner = (0, _useObservable.default)(hasHeaderBanner$());
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return hasHeaderBanner ? `calc(${EUI_HEADER_HEIGHT} + ${euiTheme.size.xl})` : undefined;
};
const usePanelBottomOffset = () => {
  const isPolicySettingsVisible = (0, _policy_hooks.useIsPolicySettingsBarVisible)();
  const [isTimelineBottomBarVisible] = (0, _use_show_timeline.useShowTimeline)();
  return isTimelineBottomBarVisible || isPolicySettingsVisible ? BOTTOM_BAR_HEIGHT : undefined;
};

/**
 * Main security navigation component.
 * It takes the links to render from the generic application `links` configs.
 */
const SecuritySideNav = () => {
  const [items, footerItems] = useSolutionSideNavItems();
  const selectedId = useSelectedId();
  const panelTopOffset = usePanelTopOffset();
  const panelBottomOffset = usePanelBottomOffset();
  if (items.length === 0 && footerItems.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "data-test-subj": "sideNavLoader"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_securitySolutionSideNav.SolutionSideNav, {
    items: items,
    footerItems: footerItems,
    selectedId: selectedId,
    panelTopOffset: panelTopOffset,
    panelBottomOffset: panelBottomOffset,
    tracker: _telemetry.track
  });
};
exports.SecuritySideNav = SecuritySideNav;