"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAppRootNavLink = exports.useAppNavLinks = void 0;
var _react = require("react");
var _links = require("../../links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAppNavLinks = () => {
  const appLinks = (0, _links.useAppLinks)();
  const navLinks = (0, _react.useMemo)(() => formatNavLinkItems(appLinks), [appLinks]);
  return navLinks;
};
exports.useAppNavLinks = useAppNavLinks;
const useAppRootNavLink = linkId => {
  return useAppNavLinks().find(({
    id
  }) => id === linkId);
};
exports.useAppRootNavLink = useAppRootNavLink;
const formatNavLinkItems = appLinks => appLinks.map(link => ({
  id: link.id,
  title: link.title,
  ...(link.categories != null ? {
    categories: link.categories
  } : {}),
  ...(link.description != null ? {
    description: link.description
  } : {}),
  ...(link.sideNavDisabled === true ? {
    disabled: true
  } : {}),
  ...(link.landingIcon != null ? {
    icon: link.landingIcon
  } : {}),
  ...(link.landingImage != null ? {
    image: link.landingImage
  } : {}),
  ...(link.skipUrlState != null ? {
    skipUrlState: link.skipUrlState
  } : {}),
  ...(link.isBeta != null ? {
    isBeta: link.isBeta
  } : {}),
  ...(link.betaOptions != null ? {
    betaOptions: link.betaOptions
  } : {}),
  ...(link.links && link.links.length ? {
    links: formatNavLinkItems(link.links)
  } : {})
}));