"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsGroupedNavigationEnabled = exports.getSearch = void 0;
var _kibana = require("../../lib/kibana");
var _constants = require("../../../../common/constants");
var _links = require("../../links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSearch = (pageName, globalQueryString) => (0, _links.needsUrlState)(pageName) && globalQueryString.length > 0 ? `?${globalQueryString}` : '';

/**
 * Hook to check if the new grouped navigation is enabled on both experimental flag and advanced settings
 * TODO: remove this function when flag and setting not needed
 */
exports.getSearch = getSearch;
const useIsGroupedNavigationEnabled = () => {
  const [groupedNavSettingEnabled] = (0, _kibana.useUiSetting$)(_constants.ENABLE_GROUPED_NAVIGATION);
  return groupedNavSettingEnabled;
};
exports.useIsGroupedNavigationEnabled = useIsGroupedNavigationEnabled;