"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetBreadcrumbs = exports.getBreadcrumbsForRoute = void 0;
var _fp = require("lodash/fp");
var _reactRedux = require("react-redux");
var _analytics = require("@kbn/analytics");
var _utils = require("../../../../explore/hosts/pages/details/utils");
var _details = require("../../../../explore/network/pages/details");
var _utils2 = require("../../../../detections/pages/detection_engine/rules/utils");
var _pages = require("../../../../exceptions/utils/pages.utils");
var _breadcrumbs = require("../../../../cloud_security_posture/breadcrumbs");
var _utils3 = require("../../../../explore/users/pages/details/utils");
var _breadcrumbs2 = require("../../../../kubernetes/pages/utils/breadcrumbs");
var _breadcrumbs3 = require("../../../../detections/pages/alert_details/utils/breadcrumbs");
var _utils4 = require("../../../../dashboards/pages/utils");
var _types = require("../../../../app/types");
var _timeline = require("../../../../timelines/store/timeline");
var _timeline2 = require("../../../../../common/types/timeline");
var _get_breadcrumbs_for_page = require("./get_breadcrumbs_for_page");
var _link_to = require("../../link_to");
var _helpers = require("../helpers");
var _telemetry = require("../../../lib/telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSetBreadcrumbs = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getSecuritySolutionUrl = (0, _link_to.useGetSecuritySolutionUrl)();
  const isGroupedNavigationEnabled = (0, _helpers.useIsGroupedNavigationEnabled)();
  return (spyState, chrome, navigateToUrl) => {
    const breadcrumbs = getBreadcrumbsForRoute(spyState, getSecuritySolutionUrl, isGroupedNavigationEnabled);
    if (!breadcrumbs) {
      return;
    }
    chrome.setBreadcrumbs(breadcrumbs.map(breadcrumb => ({
      ...breadcrumb,
      ...(breadcrumb.href && !breadcrumb.onClick ? {
        onClick: ev => {
          var _breadcrumb$href$spli, _breadcrumb$href;
          ev.preventDefault();
          const trakedPath = (_breadcrumb$href$spli = (_breadcrumb$href = breadcrumb.href) === null || _breadcrumb$href === void 0 ? void 0 : _breadcrumb$href.split('?')[0]) !== null && _breadcrumb$href$spli !== void 0 ? _breadcrumb$href$spli : 'unknown';
          (0, _telemetry.track)(_analytics.METRIC_TYPE.CLICK, `${_telemetry.TELEMETRY_EVENT.BREADCRUMB}${trakedPath}`);
          dispatch(_timeline.timelineActions.showTimeline({
            id: _timeline2.TimelineId.active,
            show: false
          }));

          // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
          navigateToUrl(breadcrumb.href);
        }
      } : {})
    })));
  };
};
exports.useSetBreadcrumbs = useSetBreadcrumbs;
const getBreadcrumbsForRoute = (object, getSecuritySolutionUrl, isGroupedNavigationEnabled) => {
  const spyState = (0, _fp.omit)('navTabs', object);
  if (!spyState || !object.navTabs || !spyState.pageName || spyState.pageName === _types.SecurityPageName.case) {
    return null;
  }
  const newMenuLeadingBreadcrumbs = (0, _get_breadcrumbs_for_page.getLeadingBreadcrumbsForSecurityPage)(spyState.pageName, getSecuritySolutionUrl, object.navTabs, isGroupedNavigationEnabled);

  // last newMenuLeadingBreadcrumbs is the current page
  const pageBreadcrumb = newMenuLeadingBreadcrumbs[newMenuLeadingBreadcrumbs.length - 1];
  const siemRootBreadcrumb = newMenuLeadingBreadcrumbs[0];
  const leadingBreadcrumbs = isGroupedNavigationEnabled ? newMenuLeadingBreadcrumbs : [siemRootBreadcrumb, pageBreadcrumb];
  return emptyLastBreadcrumbUrl([...leadingBreadcrumbs, ...getTrailingBreadcrumbsForRoutes(spyState, getSecuritySolutionUrl)]);
};
exports.getBreadcrumbsForRoute = getBreadcrumbsForRoute;
const getTrailingBreadcrumbsForRoutes = (spyState, getSecuritySolutionUrl) => {
  switch (spyState.pageName) {
    case _types.SecurityPageName.hosts:
      return (0, _utils.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.network:
      return (0, _details.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.users:
      return (0, _utils3.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.rules:
    case _types.SecurityPageName.rulesCreate:
      return (0, _utils2.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.exceptions:
      return (0, _pages.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.kubernetes:
      return (0, _breadcrumbs2.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.alerts:
      return (0, _breadcrumbs3.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.cloudSecurityPostureBenchmarks:
      return (0, _breadcrumbs.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.dashboards:
      return (0, _utils4.getTrailingBreadcrumbs)(spyState);
  }
  return [];
};
const emptyLastBreadcrumbUrl = breadcrumbs => {
  const leadingBreadCrumbs = breadcrumbs.slice(0, -1);
  const lastBreadcrumb = (0, _fp.last)(breadcrumbs);
  if (lastBreadcrumb) {
    return [...leadingBreadCrumbs, {
      ...lastBreadcrumb,
      href: ''
    }];
  }
  return breadcrumbs;
};