"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLeadingBreadcrumbsForSecurityPage = void 0;
var _types = require("../../../../app/types");
var _constants = require("../../../../../common/constants");
var _redirect_to_landing = require("../../link_to/redirect_to_landing");
var _links = require("../../../links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLeadingBreadcrumbsForSecurityPage = (pageName, getSecuritySolutionUrl, navTabs, isGroupedNavigationEnabled) => {
  const landingPath = getSecuritySolutionUrl({
    deepLinkId: _types.SecurityPageName.landing
  });
  const siemRootBreadcrumb = {
    text: _constants.APP_NAME,
    href: (0, _redirect_to_landing.getAppLandingUrl)(landingPath)
  };
  const breadcrumbs = (0, _links.getAncestorLinksInfo)(pageName).map(({
    title,
    id
  }) => {
    const newTitle = title;
    // Get title from navTabs because pages title on the new structure might be different.
    const oldTitle = navTabs[id] ? navTabs[id].name : title;
    return {
      text: isGroupedNavigationEnabled ? newTitle : oldTitle,
      href: getSecuritySolutionUrl({
        deepLinkId: id
      })
    };
  });
  return [siemRootBreadcrumb, ...breadcrumbs];
};
exports.getLeadingBreadcrumbsForSecurityPage = getLeadingBreadcrumbsForSecurityPage;