"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPGRADE_TITLE = exports.UPGRADE_BUTTON = exports.MODULE_NOT_COMPATIBLE_TITLE = exports.ML_JOB_SETTINGS = exports.LICENSE_BUTTON = exports.ANOMALY_DETECTION_DOCS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ML_JOB_SETTINGS = _i18n.i18n.translate('xpack.securitySolution.components.mlPopup.mlJobSettingsButtonLabel', {
  defaultMessage: 'ML job settings'
});
exports.ML_JOB_SETTINGS = ML_JOB_SETTINGS;
const UPGRADE_TITLE = _i18n.i18n.translate('xpack.securitySolution.components.mlPopup.upgradeTitle', {
  defaultMessage: 'Upgrade to Elastic Platinum'
});
exports.UPGRADE_TITLE = UPGRADE_TITLE;
const UPGRADE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.components.mlPopup.upgradeButtonLabel', {
  defaultMessage: 'Subscription plans'
});
exports.UPGRADE_BUTTON = UPGRADE_BUTTON;
const LICENSE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.components.mlPopup.licenseButtonLabel', {
  defaultMessage: 'Manage license'
});
exports.LICENSE_BUTTON = LICENSE_BUTTON;
const MODULE_NOT_COMPATIBLE_TITLE = incompatibleJobCount => _i18n.i18n.translate('xpack.securitySolution.components.mlPopup.moduleNotCompatibleTitle', {
  values: {
    incompatibleJobCount
  },
  defaultMessage: '{incompatibleJobCount} {incompatibleJobCount, plural, =1 {job is} other {jobs are}} currently unavailable'
});
exports.MODULE_NOT_COMPATIBLE_TITLE = MODULE_NOT_COMPATIBLE_TITLE;
const ANOMALY_DETECTION_DOCS = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.AnomalyDetectionDocsTitle', {
  defaultMessage: 'Anomaly Detection with Machine Learning'
});
exports.ANOMALY_DETECTION_DOCS = ANOMALY_DETECTION_DOCS;