"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobsTableFiltersComponent = exports.JobsTableFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _groups_filter_popover = require("./groups_filter_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Collection of filters for filtering data within the JobsTable. Contains search bar, Elastic/Custom
 * Jobs filter button toggle, and groups selection
 *
 * @param securityJobs jobs to fetch groups from to display for filtering
 * @param onFilterChanged change listener to be notified on filter changes
 */
const JobsTableFiltersComponent = ({
  securityJobs,
  onFilterChanged
}) => {
  const [filterQuery, setFilterQuery] = (0, _react.useState)('');
  const [selectedGroups, setSelectedGroups] = (0, _react.useState)([]);
  const [showCustomJobs, setShowCustomJobs] = (0, _react.useState)(false);
  const [showElasticJobs, setShowElasticJobs] = (0, _react.useState)(false);

  // Propagate filter changes to parent
  (0, _react.useEffect)(() => {
    onFilterChanged({
      filterQuery,
      showCustomJobs,
      showElasticJobs,
      selectedGroups
    });
  }, [filterQuery, selectedGroups, showCustomJobs, showElasticJobs, onFilterChanged]);
  const handleChange = (0, _react.useCallback)(query => setFilterQuery(query.queryText.trim()), [setFilterQuery]);
  const handleElasticJobsClick = (0, _react.useCallback)(() => {
    setShowElasticJobs(!showElasticJobs);
    setShowCustomJobs(false);
  }, [setShowElasticJobs, showElasticJobs, setShowCustomJobs]);
  const handleCustomJobsClick = (0, _react.useCallback)(() => {
    setShowCustomJobs(!showCustomJobs);
    setShowElasticJobs(false);
  }, [setShowElasticJobs, showCustomJobs, setShowCustomJobs]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    "data-test-subj": "jobs-filter-bar",
    box: {
      placeholder: i18n.FILTER_PLACEHOLDER,
      incremental: true
    },
    onChange: handleChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_groups_filter_popover.GroupsFilterPopover, {
    securityJobs: securityJobs,
    onSelectedGroupsChanged: setSelectedGroups
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    hasActiveFilters: showElasticJobs,
    onClick: handleElasticJobsClick,
    "data-test-subj": "show-elastic-jobs-filter-button",
    withNext: true
  }, i18n.SHOW_ELASTIC_JOBS), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    hasActiveFilters: showCustomJobs,
    onClick: handleCustomJobsClick,
    "data-test-subj": "show-custom-jobs-filter-button"
  }, i18n.SHOW_CUSTOM_JOBS))));
};
exports.JobsTableFiltersComponent = JobsTableFiltersComponent;
JobsTableFiltersComponent.displayName = 'JobsTableFiltersComponent';
const JobsTableFilters = /*#__PURE__*/_react.default.memo(JobsTableFiltersComponent);
exports.JobsTableFilters = JobsTableFilters;
JobsTableFilters.displayName = 'JobsTableFilters';