"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyScoreComponent = exports.AnomalyScore = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _score = require("./score");
var _create_description_list = require("./create_description_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Icon = (0, _styledComponents.default)(_eui.EuiIcon)`
  vertical-align: text-bottom;
  cursor: pointer;
`;
Icon.displayName = 'Icon';
const AnomalyScoreComponent = ({
  startDate,
  endDate,
  index = 0,
  score,
  interval,
  narrowDateRange,
  jobName
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "anomaly-score"
  }, /*#__PURE__*/_react.default.createElement(_score.Score, {
    index: index,
    score: score
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "anomaly-score-popover",
    id: "anomaly-score-popover",
    isOpen: isOpen,
    onClick: () => setIsOpen(!isOpen),
    closePopover: () => setIsOpen(!isOpen),
    button: /*#__PURE__*/_react.default.createElement(Icon, {
      type: "iInCircle"
    }),
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "anomaly-description-list",
    listItems: (0, _create_description_list.createDescriptionList)(score, startDate, endDate, interval, narrowDateRange, jobName)
  }))));
};
exports.AnomalyScoreComponent = AnomalyScoreComponent;
AnomalyScoreComponent.displayName = 'AnomalyScoreComponent';
const AnomalyScore = /*#__PURE__*/_react.default.memo(AnomalyScoreComponent);
exports.AnomalyScore = AnomalyScore;
AnomalyScore.displayName = 'AnomalyScore';