"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.networkToCriteria = void 0;
var _search_strategy = require("../../../../../common/search_strategy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const networkToCriteria = (ip, flowTarget) => {
  if (flowTarget === _search_strategy.FlowTargetSourceDest.source) {
    return [{
      fieldName: 'source.ip',
      fieldValue: ip
    }];
  } else if (flowTarget === _search_strategy.FlowTargetSourceDest.destination) {
    return [{
      fieldName: 'destination.ip',
      fieldValue: ip
    }];
  } else {
    return [];
  }
};
exports.networkToCriteria = networkToCriteria;