"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tryParseResponse = exports.throwIfErrorAttachedToSetup = exports.throwIfErrorAttached = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
var _toasters = require("../../toasters");
var _errors = require("./errors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tryParseResponse = response => {
  try {
    return JSON.stringify(JSON.parse(response), null, 2);
  } catch (error) {
    return response;
  }
};
exports.tryParseResponse = tryParseResponse;
const throwIfErrorAttachedToSetup = (setupResponse, jobIdErrorFilter = []) => {
  const jobErrors = setupResponse.jobs.reduce((accum, job) => {
    if (job.error != null && jobIdErrorFilter.includes(job.id)) {
      if ((0, _errors.isMlStartJobError)(job)) {
        return [...accum, job.error.msg, tryParseResponse(job.error.response), `${i18n.STATUS_CODE} ${job.error.statusCode}`];
      } else if ((0, _errors.isUnknownError)(job)) {
        return [job.error.error.reason];
      }
    }
    return accum;
  }, []);
  const dataFeedErrors = setupResponse.datafeeds.reduce((accum, dataFeed) => dataFeed.error != null && jobIdErrorFilter.includes(dataFeed.id.substr('datafeed-'.length)) ? [...accum, dataFeed.error.msg, tryParseResponse(dataFeed.error.response), `${i18n.STATUS_CODE} ${dataFeed.error.statusCode}`] : accum, []);
  const errors = [...jobErrors, ...dataFeedErrors];
  if (errors.length > 0) {
    throw new _toasters.ToasterError(errors);
  }
};
exports.throwIfErrorAttachedToSetup = throwIfErrorAttachedToSetup;
const throwIfErrorAttached = (json, dataFeedIds) => {
  const errors = dataFeedIds.reduce((accum, dataFeedId) => {
    const dataFeed = json[dataFeedId];
    if ((0, _errors.isMlStartJobError)(dataFeed)) {
      return [...accum, dataFeed.error.msg, tryParseResponse(dataFeed.error.response), `${i18n.STATUS_CODE} ${dataFeed.error.statusCode}`];
    } else if ((0, _errors.isUnknownError)(dataFeed)) {
      return [dataFeed.error.error.reason];
    } else {
      return accum;
    }
  }, []);
  if (errors.length > 0) {
    throw new _toasters.ToasterError(errors);
  }
};
exports.throwIfErrorAttached = throwIfErrorAttached;