"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MatrixHistogramComponent = exports.MatrixHistogram = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var i18n = _interopRequireWildcard(require("./translations"));
var _header_section = require("../header_section");
var _panel = require("../panel");
var _utils = require("./utils");
var _matrix_histogram = require("../../containers/matrix_histogram");
var _actions = require("../../store/inputs/actions");
var _constants = require("../../store/inputs/constants");
var _hover_visibility_container = require("../hover_visibility_container");
var _actions2 = require("../visualization_actions/actions");
var _query_toggle = require("../../containers/query_toggle");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _utils2 = require("../visualization_actions/utils");
var _visualization_embeddable = require("../visualization_actions/visualization_embeddable");
var _chart_content = require("./chart_content");
var _use_visualization_response = require("../visualization_actions/use_visualization_response");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PANEL_HEIGHT = 300;
const HistogramPanel = (0, _styledComponents.default)(_panel.Panel)`
  display: flex;
  flex-direction: column;
  ${({
  height
}) => height != null ? `min-height: ${height}px;` : ''}
`;
const CHART_HEIGHT = 150;
const visualizationResponseHasData = response => {
  var _response$aggregation;
  return Object.values((_response$aggregation = response.aggregations) !== null && _response$aggregation !== void 0 ? _response$aggregation : {}).some(({
    buckets
  }) => buckets.length > 0);
};
const MatrixHistogramComponent = ({
  chartHeight,
  defaultStackByOption,
  endDate,
  errorMessage,
  filterQuery,
  getLensAttributes,
  headerChildren,
  histogramType,
  hideHistogramIfEmpty = false,
  id,
  indexNames,
  runtimeMappings,
  isPtrIncluded,
  legendPosition,
  lensAttributes,
  mapping,
  onError,
  paddingSize = 'm',
  panelHeight = DEFAULT_PANEL_HEIGHT,
  setAbsoluteRangeDatePickerTarget = _constants.InputsModelId.global,
  setQuery,
  showInspectButton = false,
  showLegend,
  showSpacer = true,
  stackByOptions,
  startDate,
  subtitle,
  scopeId,
  title,
  titleSize,
  yTickFormatter,
  skip,
  hideQueryToggle = false
}) => {
  const visualizationId = `${id}-embeddable`;
  const dispatch = (0, _reactRedux.useDispatch)();
  const handleBrushEnd = (0, _react.useCallback)(({
    x
  }) => {
    if (!x) {
      return;
    }
    const [min, max] = x;
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: setAbsoluteRangeDatePickerTarget,
      from: new Date(min).toISOString(),
      to: new Date(max).toISOString()
    }));
  }, [dispatch, setAbsoluteRangeDatePickerTarget]);
  const barchartConfigs = (0, _react.useMemo)(() => (0, _utils.getBarchartConfigs)({
    chartHeight,
    from: startDate,
    legendPosition,
    to: endDate,
    onBrushEnd: handleBrushEnd,
    yTickFormatter,
    showLegend
  }), [chartHeight, startDate, legendPosition, endDate, handleBrushEnd, yTickFormatter, showLegend]);
  const [isInitialLoading, setIsInitialLoading] = (0, _react.useState)(true);
  const [selectedStackByOption, setSelectedStackByOption] = (0, _react.useState)(defaultStackByOption);
  (0, _react.useEffect)(() => {
    setSelectedStackByOption(defaultStackByOption);
  }, [defaultStackByOption]);
  const setSelectedChartOptionCallback = (0, _react.useCallback)(event => {
    var _stackByOptions$find;
    setSelectedStackByOption((_stackByOptions$find = stackByOptions.find(co => co.value === event.target.value)) !== null && _stackByOptions$find !== void 0 ? _stackByOptions$find : defaultStackByOption);
  }, [defaultStackByOption, stackByOptions]);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(id);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const toggleQuery = (0, _react.useCallback)(status => {
    setToggleStatus(status);
    // toggle on = skipQuery false
    setQuerySkip(!status);
  }, [setQuerySkip, setToggleStatus]);
  const isChartEmbeddablesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('chartEmbeddablesEnabled');
  const matrixHistogramRequest = {
    endDate,
    errorMessage,
    filterQuery,
    histogramType,
    indexNames,
    onError,
    startDate,
    stackByField: selectedStackByOption.value,
    runtimeMappings,
    isPtrIncluded,
    skip: querySkip || isChartEmbeddablesEnabled
  };
  const [loading, {
    data,
    inspect,
    totalCount,
    refetch
  }] = (0, _matrix_histogram.useMatrixHistogramCombined)(matrixHistogramRequest);
  const titleWithStackByField = (0, _react.useMemo)(() => title != null && typeof title === 'function' ? title(selectedStackByOption) : title, [title, selectedStackByOption]);
  const visualizationResponse = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId
  });
  const subtitleWithCounts = (0, _react.useMemo)(() => {
    if (isInitialLoading) {
      return null;
    }
    if (typeof subtitle === 'function') {
      if (isChartEmbeddablesEnabled) {
        if (!visualizationResponse || !visualizationResponseHasData(visualizationResponse[0])) {
          return subtitle(0);
        }
        const visualizationCount = visualizationResponse[0].hits.total;
        return visualizationCount >= 0 ? subtitle(visualizationCount) : null;
      } else {
        return totalCount >= 0 ? subtitle(totalCount) : null;
      }
    }
    return subtitle;
  }, [isChartEmbeddablesEnabled, isInitialLoading, subtitle, totalCount, visualizationResponse]);
  const hideHistogram = (0, _react.useMemo)(() => totalCount <= 0 && hideHistogramIfEmpty ? true : false, [totalCount, hideHistogramIfEmpty]);
  const barChartData = (0, _react.useMemo)(() => (0, _utils.getCustomChartData)(data, mapping), [data, mapping]);
  (0, _react.useEffect)(() => {
    if (!loading && !isInitialLoading) {
      setQuery({
        id,
        inspect,
        loading,
        refetch
      });
    }
    if (isInitialLoading && !!barChartData && data) {
      setIsInitialLoading(false);
    }
  }, [barChartData, data, id, inspect, isChartEmbeddablesEnabled, isInitialLoading, loading, refetch, setIsInitialLoading, setQuery]);
  const timerange = (0, _react.useMemo)(() => ({
    from: startDate,
    to: endDate
  }), [startDate, endDate]);
  const extraVisualizationOptions = (0, _react.useMemo)(() => ({
    dnsIsPtrIncluded: isPtrIncluded !== null && isPtrIncluded !== void 0 ? isPtrIncluded : false
  }), [isPtrIncluded]);
  if (hideHistogram) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    show: !isInitialLoading,
    targetClassNames: [_utils2.VISUALIZATION_ACTIONS_BUTTON_CLASS]
  }, /*#__PURE__*/_react.default.createElement(HistogramPanel, {
    "data-test-subj": `${id}Panel`,
    height: toggleStatus ? panelHeight : undefined,
    paddingSize: paddingSize
  }, loading && !isInitialLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "initialLoadingPanelMatrixOverTime",
    size: "xs",
    position: "absolute",
    color: "accent"
  }), /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: id,
    height: toggleStatus ? undefined : 0,
    title: titleWithStackByField,
    titleSize: titleSize,
    toggleStatus: toggleStatus,
    toggleQuery: hideQueryToggle ? undefined : toggleQuery,
    subtitle: subtitleWithCounts,
    inspectMultiple: true,
    showInspectButton: showInspectButton && !isChartEmbeddablesEnabled,
    isInspectDisabled: filterQuery === undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, (getLensAttributes || lensAttributes) && timerange && !isChartEmbeddablesEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_actions2.VisualizationActions, {
    className: "histogram-viz-actions",
    extraOptions: extraVisualizationOptions,
    getLensAttributes: getLensAttributes,
    isInspectButtonDisabled: filterQuery === undefined,
    lensAttributes: lensAttributes,
    queryId: id,
    stackByField: selectedStackByOption.value,
    timerange: timerange,
    title: title
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, stackByOptions.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    onChange: setSelectedChartOptionCallback,
    options: stackByOptions,
    prepend: i18n.STACK_BY,
    value: selectedStackByOption === null || selectedStackByOption === void 0 ? void 0 : selectedStackByOption.value
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, headerChildren))), toggleStatus ? isChartEmbeddablesEnabled ? /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "embeddable-matrix-histogram",
    extraOptions: extraVisualizationOptions,
    getLensAttributes: getLensAttributes,
    height: chartHeight !== null && chartHeight !== void 0 ? chartHeight : CHART_HEIGHT,
    id: visualizationId,
    inspectTitle: title,
    lensAttributes: lensAttributes,
    stackByField: selectedStackByOption.value,
    timerange: timerange
  }) : /*#__PURE__*/_react.default.createElement(_chart_content.MatrixHistogramChartContent, {
    isInitialLoading: isInitialLoading,
    barChart: barChartData,
    configs: barchartConfigs,
    stackByField: selectedStackByOption.value,
    scopeId: scopeId
  }) : null)), showSpacer && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    "data-test-subj": "spacer",
    size: "l"
  }));
};
exports.MatrixHistogramComponent = MatrixHistogramComponent;
const MatrixHistogram = /*#__PURE__*/_react.default.memo(MatrixHistogramComponent);
exports.MatrixHistogram = MatrixHistogram;