"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MatrixHistogramChartContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _barchart = require("../charts/barchart");
var _matrix_loader = require("./matrix_loader");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MatrixHistogramChartContentComponent = ({
  isInitialLoading,
  barChart,
  configs,
  stackByField,
  scopeId
}) => {
  return isInitialLoading ? /*#__PURE__*/_react.default.createElement(_matrix_loader.MatrixLoader, null) : /*#__PURE__*/_react.default.createElement(_barchart.BarChart, {
    barChart: barChart,
    configs: configs,
    stackByField: stackByField,
    scopeId: scopeId
  });
};
const MatrixHistogramChartContent = /*#__PURE__*/_react.default.memo(MatrixHistogramChartContentComponent);
exports.MatrixHistogramChartContent = MatrixHistogramChartContent;
MatrixHistogramChartContentComponent.displayName = 'MatrixHistogramChartContentComponent';