"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _investigation_guide_view = require("../../../event_details/investigation_guide_view");
var _expand_dotted = require("../../../../../../common/utils/expand_dotted");
var _osquery = _interopRequireDefault(require("./osquery_icon/osquery.svg"));
var _osquery_flyout = require("../../../../../detections/components/osquery/osquery_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// receives the configuration from the parser and renders

const StyledEuiButton = (0, _styledComponents.default)(_eui.EuiButton)`
  > span > img {
    margin-block-end: 0;
  }
`;
const OsqueryRenderer = ({
  configuration
}) => {
  var _configuration$label;
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const {
    agentId,
    alertId,
    data
  } = (0, _react.useContext)(_investigation_guide_view.BasicAlertDataContext);
  const handleOpen = (0, _react.useCallback)(() => setShowFlyout(true), [setShowFlyout]);
  const handleClose = (0, _react.useCallback)(() => setShowFlyout(false), [setShowFlyout]);
  const ecsData = (0, _react.useMemo)(() => {
    const fieldsMap = (0, _lodash.reduce)(data, (acc, eventDetailItem) => {
      var _eventDetailItem$valu;
      return {
        ...acc,
        [eventDetailItem.field]: eventDetailItem === null || eventDetailItem === void 0 ? void 0 : (_eventDetailItem$valu = eventDetailItem.values) === null || _eventDetailItem$valu === void 0 ? void 0 : _eventDetailItem$valu[0]
      };
    }, {});
    return (0, _expand_dotted.expandDottedObject)(fieldsMap);
  }, [data]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledEuiButton, {
    iconType: _osquery.default,
    onClick: handleOpen
  }, (_configuration$label = configuration.label) !== null && _configuration$label !== void 0 ? _configuration$label : _i18n.i18n.translate('xpack.securitySolution.markdown.osquery.runOsqueryButtonLabel', {
    defaultMessage: 'Run Osquery'
  })), showFlyout && /*#__PURE__*/_react.default.createElement(_osquery_flyout.OsqueryFlyout, {
    defaultValues: {
      ...(alertId ? {
        alertIds: [alertId]
      } : {}),
      query: configuration.query,
      ecs_mapping: configuration.ecs_mapping,
      queryField: false
    },
    agentId: agentId,
    onClose: handleClose,
    ecsData: ecsData
  }));
};
exports.OsqueryRenderer = OsqueryRenderer;