"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiPlugins = exports.processingPlugins = exports.parsingPlugins = void 0;
var _eui = require("@elastic/eui");
var timelineMarkdownPlugin = _interopRequireWildcard(require("./timeline"));
var osqueryMarkdownPlugin = _interopRequireWildcard(require("./osquery"));
var insightMarkdownPlugin = _interopRequireWildcard(require("./insight"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  uiPlugins,
  parsingPlugins,
  processingPlugins
} = {
  uiPlugins: (0, _eui.getDefaultEuiMarkdownUiPlugins)(),
  parsingPlugins: (0, _eui.getDefaultEuiMarkdownParsingPlugins)(),
  processingPlugins: (0, _eui.getDefaultEuiMarkdownProcessingPlugins)()
};
exports.processingPlugins = processingPlugins;
exports.parsingPlugins = parsingPlugins;
exports.uiPlugins = uiPlugins;
uiPlugins.push(timelineMarkdownPlugin.plugin);
uiPlugins.push(osqueryMarkdownPlugin.plugin);
uiPlugins.push(insightMarkdownPlugin.plugin);
parsingPlugins.push(insightMarkdownPlugin.parser);
parsingPlugins.push(timelineMarkdownPlugin.parser);
parsingPlugins.push(osqueryMarkdownPlugin.parser);

// This line of code is TS-compatible and it will break if [1][1] change in the future.
processingPlugins[1][1].components.insight = insightMarkdownPlugin.renderer;
processingPlugins[1][1].components.timeline = timelineMarkdownPlugin.renderer;
processingPlugins[1][1].components.osquery = osqueryMarkdownPlugin.renderer;