"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownEditorForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _editor = require("./editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BottomContentWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  ${({
  theme
}) => `
    padding: ${theme.eui.euiSizeM} 0;
  `}
`;
const MarkdownEditorForm = /*#__PURE__*/_react.default.memo( /*#__PURE__*/(0, _react.forwardRef)(({
  id,
  field,
  dataTestSubj,
  idAria,
  bottomRightContent
}, ref) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    error: errorMessage,
    fullWidth: true,
    helpText: field.helpText,
    isInvalid: isInvalid,
    label: field.label,
    labelAppend: field.labelAppend
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_editor.MarkdownEditor, {
    ref: ref,
    ariaLabel: idAria,
    editorId: id,
    onChange: field.setValue,
    value: field.value,
    "data-test-subj": `${dataTestSubj}-markdown-editor`
  }), bottomRightContent && /*#__PURE__*/_react.default.createElement(BottomContentWrapper, {
    justifyContent: 'flexEnd'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, bottomRightContent))));
}));
exports.MarkdownEditorForm = MarkdownEditorForm;
MarkdownEditorForm.displayName = 'MarkdownEditorForm';