"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOLUTION_REQUIREMENTS_LINK_TEXT = exports.SOLUTION_REQUIREMENTS_LINK_PATH = exports.ML_JOB_COMPATIBILITY_LINK_TEXT = exports.ML_JOB_COMPATIBILITY_LINK_PATH = exports.DETECTIONS_REQUIREMENTS_LINK_TEXT = exports.DETECTIONS_REQUIREMENTS_LINK_PATH = exports.COMMON_ARIA_LABEL_ENDING = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * If a link's text is "Docs", its aria-label will be set to
 * "Docs - ${COMMON_ARIA_LABEL_ENDING}".
 */
const COMMON_ARIA_LABEL_ENDING = _i18n.i18n.translate('xpack.securitySolution.documentationLinks.ariaLabelEnding', {
  defaultMessage: 'click to open documentation in a new tab'
});
exports.COMMON_ARIA_LABEL_ENDING = COMMON_ARIA_LABEL_ENDING;
const SOLUTION_REQUIREMENTS_LINK_PATH = 'sec-requirements.html';
exports.SOLUTION_REQUIREMENTS_LINK_PATH = SOLUTION_REQUIREMENTS_LINK_PATH;
const SOLUTION_REQUIREMENTS_LINK_TEXT = _i18n.i18n.translate('xpack.securitySolution.documentationLinks.solutionRequirements.text', {
  defaultMessage: 'Elastic Security system requirements'
});
exports.SOLUTION_REQUIREMENTS_LINK_TEXT = SOLUTION_REQUIREMENTS_LINK_TEXT;
const DETECTIONS_REQUIREMENTS_LINK_PATH = 'detections-permissions-section.html';
exports.DETECTIONS_REQUIREMENTS_LINK_PATH = DETECTIONS_REQUIREMENTS_LINK_PATH;
const DETECTIONS_REQUIREMENTS_LINK_TEXT = _i18n.i18n.translate('xpack.securitySolution.documentationLinks.detectionsRequirements.text', {
  defaultMessage: 'Detections prerequisites and requirements'
});
exports.DETECTIONS_REQUIREMENTS_LINK_TEXT = DETECTIONS_REQUIREMENTS_LINK_TEXT;
const ML_JOB_COMPATIBILITY_LINK_PATH = 'alerts-ui-monitor.html#ml-job-compatibility';
exports.ML_JOB_COMPATIBILITY_LINK_PATH = ML_JOB_COMPATIBILITY_LINK_PATH;
const ML_JOB_COMPATIBILITY_LINK_TEXT = _i18n.i18n.translate('xpack.securitySolution.documentationLinks.mlJobCompatibility.text', {
  defaultMessage: 'ML job compatibility'
});
exports.ML_JOB_COMPATIBILITY_LINK_TEXT = ML_JOB_COMPATIBILITY_LINK_TEXT;