"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A link for opening external urls in a new browser tab.
 */
const ExternalLink = ({
  url,
  children,
  ariaLabel
}) => {
  if (!children) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: url,
    position: "top",
    "data-test-subj": "externalLinkTooltip"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: url,
    "aria-label": ariaLabel,
    external: true,
    target: "_blank",
    rel: "noopener",
    "data-test-subj": "externalLink"
  }, children));
};
exports.ExternalLink = ExternalLink;