"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertDetailsUrl = exports.getAlertDetailsTabUrl = void 0;
var _constants = require("../../../../common/constants");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertDetailsUrl = (alertId, search) => `/${alertId}/summary${(0, _helpers.appendSearch)(search)}`;
exports.getAlertDetailsUrl = getAlertDetailsUrl;
const getAlertDetailsTabUrl = (detailName, tabName, search) => `${_constants.ALERTS_PATH}/${detailName}/${tabName}${(0, _helpers.appendSearch)(search)}`;
exports.getAlertDetailsTabUrl = getAlertDetailsTabUrl;