"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LineClamp = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_is_overflow = require("../../hooks/use_is_overflow");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LINE_CLAMP = 3;
const LINE_CLAMP_HEIGHT = 5.5;
const ReadMore = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  span.euiButtonContent {
    padding: 0;
  }
`;
const ExpandedContent = _styledComponents.default.div`
  max-height: 33vh;
  overflow-wrap: break-word;
  overflow-x: hidden;
  overflow-y: auto;
`;
const StyledLineClamp = _styledComponents.default.div`
  display: -webkit-box;
  -webkit-line-clamp: ${LINE_CLAMP};
  -webkit-box-orient: vertical;
  overflow: hidden;
  max-height: ${({
  lineClampHeight
}) => lineClampHeight}em;
  height: ${({
  lineClampHeight
}) => lineClampHeight}em;
`;
const LineClampComponent = ({
  children,
  lineClampHeight = LINE_CLAMP_HEIGHT
}) => {
  const [isExpanded, setIsExpanded] = (0, _react.useState)(null);
  const [isOverflow, descriptionRef] = (0, _use_is_overflow.useIsOverflow)(children);
  const toggleReadMore = (0, _react.useCallback)(() => {
    setIsExpanded(prevState => !prevState);
  }, []);
  if (isExpanded) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ExpandedContent, {
      "data-test-subj": "expanded-line-clamp"
    }, /*#__PURE__*/_react.default.createElement("p", null, children)), isOverflow && /*#__PURE__*/_react.default.createElement(ReadMore, {
      onClick: toggleReadMore,
      size: "s",
      "data-test-subj": "summary-view-readmore"
    }, i18n.READ_LESS));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isOverflow == null || isOverflow === true ? /*#__PURE__*/_react.default.createElement(StyledLineClamp, {
    "data-test-subj": "styled-line-clamp",
    ref: descriptionRef,
    lineClampHeight: lineClampHeight
  }, children) : children, isOverflow && /*#__PURE__*/_react.default.createElement(ReadMore, {
    onClick: toggleReadMore,
    size: "s",
    "data-test-subj": "summary-view-readmore"
  }, i18n.READ_MORE));
};
const LineClamp = /*#__PURE__*/_react.default.memo(LineClampComponent);
exports.LineClamp = LineClamp;