"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIFY_TITLE = exports.UNIFY_DESCRIPTION = exports.SIEM_TITLE = exports.SIEM_HEADER = exports.SIEM_DESCRIPTION = exports.SIEM_CTA = exports.SIEM_CARD_TITLE = exports.SIEM_CARD_DESCRIPTION = exports.ENDPOINT_TITLE = exports.ENDPOINT_DESCRIPTION = exports.CLOUD_CARD_TITLE = exports.CLOUD_CARD_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SIEM_HEADER = _i18n.i18n.translate('xpack.securitySolution.overview.landingCards.box.siem.header', {
  defaultMessage: 'Elastic Security'
});
exports.SIEM_HEADER = SIEM_HEADER;
const SIEM_TITLE = _i18n.i18n.translate('xpack.securitySolution.overview.landingCards.box.siem.title', {
  defaultMessage: 'Security at the speed of Elastic'
});
exports.SIEM_TITLE = SIEM_TITLE;
const SIEM_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.overview.landingCards.box.siem.desc', {
  defaultMessage: 'Elastic Security equips teams to prevent, detect, and respond to threats at cloud speed and scale — securing business operations with a unified, open platform.'
});
exports.SIEM_DESCRIPTION = SIEM_DESCRIPTION;
const SIEM_CTA = _i18n.i18n.translate('xpack.securitySolution.overview.landingCards.box.siem.cta', {
  defaultMessage: 'Add security integrations'
});
exports.SIEM_CTA = SIEM_CTA;
const ENDPOINT_TITLE = _i18n.i18n.translate('xpack.securitySolution.overview.landingCards.box.endpoint.title', {
  defaultMessage: 'Endpoint security at scale'
});
exports.ENDPOINT_TITLE = ENDPOINT_TITLE;
const ENDPOINT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.overview.landingCards.box.endpoint.desc', {
  defaultMessage: 'Prevent, collect, detect and respond — all with Elastic Agent.'
});
exports.ENDPOINT_DESCRIPTION = ENDPOINT_DESCRIPTION;
const SIEM_CARD_TITLE = _i18n.i18n.translate('xpack.securitySolution.overview.landingCards.box.siemCard.title', {
  defaultMessage: 'SIEM for the modern SOC'
});
exports.SIEM_CARD_TITLE = SIEM_CARD_TITLE;
const SIEM_CARD_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.overview.landingCards.box.siemCard.desc', {
  defaultMessage: 'Detect, investigate, and respond to evolving threats in your environment.'
});
exports.SIEM_CARD_DESCRIPTION = SIEM_CARD_DESCRIPTION;
const CLOUD_CARD_TITLE = _i18n.i18n.translate('xpack.securitySolution.overview.landingCards.box.cloudCard.title', {
  defaultMessage: 'Cloud protection end-to-end'
});
exports.CLOUD_CARD_TITLE = CLOUD_CARD_TITLE;
const CLOUD_CARD_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.overview.landingCards.box.cloudCard.desc', {
  defaultMessage: 'Assess your Cloud Posture and protect your workloads from attacks.'
});
exports.CLOUD_CARD_DESCRIPTION = CLOUD_CARD_DESCRIPTION;
const UNIFY_TITLE = _i18n.i18n.translate('xpack.securitySolution.overview.landingCards.box.unify.title', {
  defaultMessage: 'Unify SIEM, endpoint security, and cloud security'
});
exports.UNIFY_TITLE = UNIFY_TITLE;
const UNIFY_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.overview.landingCards.box.unify.desc', {
  defaultMessage: 'Elastic Security modernizes security operations — enabling analytics across years of data, automating key processes, and protecting every host.'
});
exports.UNIFY_DESCRIPTION = UNIFY_DESCRIPTION;