"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectButtonContainer = exports.InspectButton = exports.BUTTON_CLASS = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../store/inputs/constants");
var _hover_visibility_container = require("../hover_visibility_container");
var _modal = require("./modal");
var _use_inspect = require("./use_inspect");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BUTTON_CLASS = 'inspectButtonComponent';
exports.BUTTON_CLASS = BUTTON_CLASS;
const InspectButtonContainer = ({
  children,
  show = true
}) => /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
  show: show,
  targetClassNames: [BUTTON_CLASS]
}, children);
exports.InspectButtonContainer = InspectButtonContainer;
const InspectButtonComponent = ({
  compact = false,
  inputId = _constants.InputsModelId.global,
  inspectIndex = 0,
  isDisabled,
  multiple = false,
  // If multiple = true we ignore the inspectIndex and pass all requests and responses to the inspect modal
  onCloseInspect,
  queryId = '',
  showInspectButton = true,
  title = ''
}) => {
  const {
    additionalRequests,
    additionalResponses,
    handleClick,
    handleCloseModal,
    isButtonDisabled,
    isShowingModal,
    loading,
    request,
    response
  } = (0, _use_inspect.useInspect)({
    inputId,
    inspectIndex,
    isDisabled,
    multiple,
    onCloseInspect,
    queryId
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, inputId === _constants.InputsModelId.timeline && !compact && showInspectButton && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: BUTTON_CLASS,
    "aria-label": i18n.INSPECT,
    "data-test-subj": "inspect-empty-button",
    color: "text",
    iconSide: "left",
    iconType: "inspect",
    isDisabled: isButtonDisabled,
    isLoading: loading,
    onClick: handleClick
  }, i18n.INSPECT), (inputId === _constants.InputsModelId.global || compact) && showInspectButton && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: BUTTON_CLASS,
    "aria-label": i18n.INSPECT,
    "data-test-subj": "inspect-icon-button",
    iconSize: "m",
    iconType: "inspect",
    isDisabled: isButtonDisabled,
    title: i18n.INSPECT,
    onClick: handleClick
  }), isShowingModal && request !== null && response !== null && /*#__PURE__*/_react.default.createElement(_modal.ModalInspectQuery, {
    additionalRequests: additionalRequests,
    additionalResponses: additionalResponses,
    closeModal: handleCloseModal,
    "data-test-subj": "inspect-modal",
    inputId: inputId,
    request: request,
    response: response,
    title: title
  }));
};
InspectButtonComponent.displayName = 'InspectButtonComponent';
const InspectButton = /*#__PURE__*/_react.default.memo(InspectButtonComponent);
exports.InspectButton = InspectButton;