"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionConnectorWarnings = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _kibana_react = require("../../../lib/kibana/kibana_react");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionConnectorWarningsComponent = ({
  actionConnectorsWarnings,
  importedActionConnectorsCount
}) => {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  if (!importedActionConnectorsCount || !actionConnectorsWarnings.length) return null;
  const {
    actionPath,
    message,
    buttonLabel
  } = actionConnectorsWarnings[0];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "actionConnectorsWarningsCallOut",
    size: "m",
    heading: "h2",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "actionConnectorsWarningsCallOutTitle"
    }, i18n.ACTION_CONNECTORS_WARNING_TITLE(importedActionConnectorsCount)),
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "actionConnectorsWarningsCallOutMessage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, message)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "columnReverse",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "actionConnectorsWarningsCallOutButton",
    color: "warning",
    href: http.basePath.prepend(actionPath)
  }, buttonLabel || i18n.ACTION_CONNECTORS_WARNING_BUTTON)))));
};
ActionConnectorWarningsComponent.displayName = 'ActionConnectorWarningsComponent';
const ActionConnectorWarnings = /*#__PURE__*/_react.default.memo(ActionConnectorWarningsComponent);
exports.ActionConnectorWarnings = ActionConnectorWarnings;
ActionConnectorWarnings.displayName = 'ActionConnectorWarnings';