"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddEventNoteAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../../../timelines/components/timeline/properties/helpers");
var _types = require("../../../../common/types");
var _user_privileges = require("../user_privileges");
var i18n = _interopRequireWildcard(require("./translations"));
var _action_icon_item = require("./action_icon_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddEventNoteActionComponent = ({
  ariaLabel,
  showNotes,
  timelineType,
  toggleShowNotes
}) => {
  const {
    kibanaSecuritySolutionsPrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  return /*#__PURE__*/_react.default.createElement(_action_icon_item.ActionIconItem, null, /*#__PURE__*/_react.default.createElement(_helpers.NotesButton, {
    ariaLabel: ariaLabel,
    "data-test-subj": "add-note",
    isDisabled: kibanaSecuritySolutionsPrivileges.crud === false,
    showNotes: showNotes,
    timelineType: timelineType,
    toggleShowNotes: toggleShowNotes,
    toolTip: timelineType === _types.TimelineType.template ? i18n.NOTES_DISABLE_TOOLTIP : i18n.NOTES_TOOLTIP
  }));
};
AddEventNoteActionComponent.displayName = 'AddEventNoteActionComponent';
const AddEventNoteAction = /*#__PURE__*/_react.default.memo(AddEventNoteActionComponent);
exports.AddEventNoteAction = AddEventNoteAction;