"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPanelsInOrderFromControlsInput = exports.getFilterItemObjListFromControlInput = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPanelsInOrderFromControlsInput = controlInput => {
  const panels = controlInput.panels;
  return Object.values(panels).sort((a, b) => a.order - b.order);
};
exports.getPanelsInOrderFromControlsInput = getPanelsInOrderFromControlsInput;
const getFilterItemObjListFromControlInput = controlInput => {
  const panels = getPanelsInOrderFromControlsInput(controlInput);
  return panels.map(panel => {
    const {
      explicitInput: {
        fieldName,
        selectedOptions,
        title,
        existsSelected,
        exclude
      }
    } = panel;
    return {
      fieldName: fieldName,
      selectedOptions: selectedOptions !== null && selectedOptions !== void 0 ? selectedOptions : [],
      title,
      existsSelected: existsSelected !== null && existsSelected !== void 0 ? existsSelected : false,
      exclude: exclude !== null && exclude !== void 0 ? exclude : false
    };
  });
};
exports.getFilterItemObjListFromControlInput = getFilterItemObjListFromControlInput;