"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilterUpdatesToUrlSync = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _react = require("react");
var _reactRedux = require("react-redux");
var _format_page_filter_search_param = require("../../../../../common/utils/format_page_filter_search_param");
var _use_url_state = require("../../../hooks/use_url_state");
var _actions = require("../../../store/global_url_param/actions");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFilterUpdatesToUrlSync = ({
  controlGroupInput
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const formattedFilters = (0, _react.useMemo)(() => {
    if (!controlGroupInput) return;
    return (0, _utils.getFilterItemObjListFromControlInput)(controlGroupInput);
  }, [controlGroupInput]);
  (0, _react.useEffect)(() => {
    if (!formattedFilters) return;
    if ((controlGroupInput === null || controlGroupInput === void 0 ? void 0 : controlGroupInput.viewMode) !== _public.ViewMode.VIEW) return;
    dispatch((0, _actions.updateUrlParam)({
      key: _use_url_state.URL_PARAM_KEY.pageFilter,
      value: (0, _format_page_filter_search_param.formatPageFilterSearchParam)(formattedFilters)
    }));
  }, [formattedFilters, dispatch, controlGroupInput]);
};
exports.useFilterUpdatesToUrlSync = useFilterUpdatesToUrlSync;