"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterGroupContextMenu = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("./constants");
var _use_filters = require("./hooks/use_filters");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterGroupContextMenu = () => {
  const [isContextMenuVisible, setIsContextMenuVisible] = (0, _react.useState)(false);
  const {
    isViewMode,
    controlGroupInputUpdates,
    controlGroup,
    switchToViewMode,
    switchToEditMode,
    initialControls,
    dataViewId,
    setShowFiltersChangedBanner,
    discardChangesHandler
  } = (0, _use_filters.useFilterGroupInternalContext)();
  const toggleContextMenu = (0, _react.useCallback)(() => {
    setIsContextMenuVisible(prev => !prev);
  }, []);
  const withContextMenuAction = (0, _react.useCallback)(fn => {
    return () => {
      if (typeof fn === 'function') {
        fn();
      }
      toggleContextMenu();
    };
  }, [toggleContextMenu]);
  const resetSelection = (0, _react.useCallback)(async () => {
    if (!controlGroupInputUpdates) return;

    // remove existing embeddables
    controlGroup === null || controlGroup === void 0 ? void 0 : controlGroup.updateInput({
      panels: {}
    });
    for (let counter = 0; counter < initialControls.length; counter++) {
      const control = initialControls[counter];
      await (controlGroup === null || controlGroup === void 0 ? void 0 : controlGroup.addOptionsListControl({
        controlId: String(counter),
        hideExclude: true,
        hideSort: true,
        hidePanelTitles: true,
        placeholder: '',
        // option List controls will handle an invalid dataview
        // & display an appropriate message
        dataViewId: dataViewId !== null && dataViewId !== void 0 ? dataViewId : '',
        ...control
      }));
    }
    switchToViewMode();
    setShowFiltersChangedBanner(false);
  }, [controlGroupInputUpdates, controlGroup, initialControls, dataViewId, switchToViewMode, setShowFiltersChangedBanner]);
  const resetButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "reset",
    icon: "eraser",
    "aria-label": _translations.CONTEXT_MENU_RESET,
    onClick: withContextMenuAction(resetSelection),
    "data-test-subj": _constants.TEST_IDS.CONTEXT_MENU.RESET,
    toolTipContent: _translations.CONTEXT_MENU_RESET_TOOLTIP
  }, _translations.CONTEXT_MENU_RESET), [withContextMenuAction, resetSelection]);
  const editControlsButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "edit",
    icon: isViewMode ? 'pencil' : 'minusInCircle',
    "aria-label": isViewMode ? _translations.EDIT_CONTROLS : _translations.DISCARD_CHANGES,
    onClick: isViewMode ? withContextMenuAction(switchToEditMode) : withContextMenuAction(discardChangesHandler),
    "data-test-subj": isViewMode ? _constants.TEST_IDS.CONTEXT_MENU.EDIT : _constants.TEST_IDS.CONTEXT_MENU.DISCARD
  }, isViewMode ? _translations.EDIT_CONTROLS : _translations.DISCARD_CHANGES), [withContextMenuAction, isViewMode, switchToEditMode, discardChangesHandler]);
  const contextMenuItems = (0, _react.useMemo)(() => [resetButton, editControlsButton], [resetButton, editControlsButton]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: _constants.TEST_IDS.CONTEXT_MENU.MENU,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _translations.FILTER_GROUP_MENU,
      display: "empty",
      size: "s",
      iconType: "boxesHorizontal",
      onClick: toggleContextMenu,
      "data-test-subj": _constants.TEST_IDS.CONTEXT_MENU.BTN
    }),
    isOpen: isContextMenuVisible,
    closePopover: toggleContextMenu,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: contextMenuItems
  }));
};
exports.FilterGroupContextMenu = FilterGroupContextMenu;