"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveControls = exports.AddControl = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_filters = require("./hooks/use_filters");
var _translations = require("./translations");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddControl = ({
  onClick,
  ...rest
}) => {
  const {
    isDisabled
  } = rest;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isDisabled ? _translations.ADD_CONTROLS_MAX_LIMIT : _translations.ADD_CONTROLS
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    size: "s",
    iconSize: "m",
    display: "base",
    "aria-label": isDisabled ? _translations.ADD_CONTROLS_MAX_LIMIT : _translations.ADD_CONTROLS,
    "data-test-subj": _constants.TEST_IDS.ADD_CONTROL,
    onClick: onClick
  }, rest, {
    iconType: "plusInCircle"
  })));
};
exports.AddControl = AddControl;
const SaveControls = ({
  onClick
}) => {
  const {
    hasPendingChanges,
    openPendingChangesPopover,
    closePendingChangesPopover,
    pendingChangesPopoverOpen
  } = (0, _use_filters.useFilterGroupInternalContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _translations.SAVE_CHANGES,
      size: "s",
      iconSize: "m",
      display: "base",
      color: "primary",
      iconType: "save",
      "data-test-subj": _constants.TEST_IDS.SAVE_CONTROL,
      onClick: onClick,
      onFocus: openPendingChangesPopover,
      onBlur: closePendingChangesPopover,
      onMouseOver: openPendingChangesPopover,
      onMouseOut: closePendingChangesPopover,
      disabled: !hasPendingChanges
    }),
    isOpen: pendingChangesPopoverOpen,
    anchorPosition: "upCenter",
    panelPaddingSize: "none",
    closePopover: closePendingChangesPopover,
    panelProps: {
      'data-test-subj': _constants.TEST_IDS.SAVE_CHANGE_POPOVER
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxWidth: '200px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _translations.PENDING_CHANGES_REMINDER,
    color: "warning",
    iconType: "alert",
    size: "s"
  })));
};
exports.SaveControls = SaveControls;