"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubtitleFunction = exports.eventsStackByOptions = exports.eventsHistogramConfig = exports.alertsStackByOptions = exports.alertsHistogramConfig = void 0;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _security_solution = require("../../../../common/search_strategy/security_solution");
var _external_alert = require("../visualization_actions/lens_attributes/common/external_alert");
var _events = require("../visualization_actions/lens_attributes/common/events");
var i18n = _interopRequireWildcard(require("./translations"));
var _eventsStackByOptions, _alertsStackByOptions;
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const DEFAULT_EVENTS_STACK_BY = 'event.action';
const getSubtitleFunction = (defaultNumberFormat, isAlert) => totalCount => `${i18n.SHOWING}: ${(0, _numeral.default)(totalCount).format(defaultNumberFormat)} ${isAlert ? i18n.EXTERNAL_ALERTS_UNIT(totalCount) : i18n.EVENTS_UNIT(totalCount)}`;
exports.getSubtitleFunction = getSubtitleFunction;
const eventsStackByOptions = [{
  text: 'event.action',
  value: 'event.action'
}, {
  text: 'event.dataset',
  value: 'event.dataset'
}, {
  text: 'event.module',
  value: 'event.module'
}];
exports.eventsStackByOptions = eventsStackByOptions;
const eventsHistogramConfig = {
  defaultStackByOption: (_eventsStackByOptions = eventsStackByOptions.find(o => o.text === DEFAULT_EVENTS_STACK_BY)) !== null && _eventsStackByOptions !== void 0 ? _eventsStackByOptions : eventsStackByOptions[0],
  errorMessage: i18n.ERROR_FETCHING_EVENTS_DATA,
  histogramType: _security_solution.MatrixHistogramType.events,
  stackByOptions: eventsStackByOptions,
  subtitle: undefined,
  title: i18n.EVENTS_GRAPH_TITLE,
  getLensAttributes: _events.getEventsHistogramLensAttributes
};
exports.eventsHistogramConfig = eventsHistogramConfig;
const alertsStackByOptions = [{
  text: 'event.category',
  value: 'event.category'
}, {
  text: 'event.module',
  value: 'event.module'
}];
exports.alertsStackByOptions = alertsStackByOptions;
const DEFAULT_STACK_BY = 'event.module';
const alertsHistogramConfig = {
  defaultStackByOption: (_alertsStackByOptions = alertsStackByOptions.find(o => o.text === DEFAULT_STACK_BY)) !== null && _alertsStackByOptions !== void 0 ? _alertsStackByOptions : alertsStackByOptions[0],
  errorMessage: i18n.ERROR_FETCHING_ALERTS_DATA,
  histogramType: _security_solution.MatrixHistogramType.alerts,
  stackByOptions: alertsStackByOptions,
  subtitle: undefined,
  title: i18n.ALERTS_GRAPH_TITLE,
  getLensAttributes: _external_alert.getExternalAlertLensAttributes
};
exports.alertsHistogramConfig = alertsHistogramConfig;