"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsQueryTabBody = exports.ALERTS_EVENTS_HISTOGRAM_ID = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _timeline = require("../../../../common/types/timeline");
var _events_viewer = require("../events_viewer");
var _default_model = require("../events_viewer/default_model");
var _matrix_histogram = require("../matrix_histogram");
var _use_full_screen = require("../../containers/use_full_screen");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../../common/constants");
var _histogram_configurations = require("./histogram_configurations");
var _control_columns = require("../../../timelines/components/timeline/body/control_columns");
var _renderers = require("../../../timelines/components/timeline/body/renderers");
var _default_cell_renderer = require("../../../timelines/components/timeline/cell_rendering/default_cell_renderer");
var _model = require("../../store/sourcerer/model");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _constants2 = require("../../../timelines/components/timeline/body/constants");
var _use_license = require("../../hooks/use_license");
var _kibana = require("../../lib/kibana");
var _external_alerts_filter = require("../events_viewer/external_alerts_filter");
var _use_add_bulk_to_timeline = require("../../../detections/components/alerts_table/timeline_actions/use_add_bulk_to_timeline");
var _helpers = require("../../utils/global_query_string/helpers");
var _cell_actions = require("../cell_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_EVENTS_HISTOGRAM_ID = 'alertsOrEventsHistogramQuery';
exports.ALERTS_EVENTS_HISTOGRAM_ID = ALERTS_EVENTS_HISTOGRAM_ID;
const EXTERNAL_ALERTS_URL_PARAM = 'onlyExternalAlerts';
const EventsQueryTabBodyComponent = ({
  additionalFilters,
  deleteQuery,
  endDate,
  filterQuery,
  indexNames,
  setQuery,
  startDate,
  tableId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const tGridEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('tGridEnabled');
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const ACTION_BUTTON_COUNT = isEnterprisePlus ? 5 : 4;
  const leadingControlColumns = (0, _react.useMemo)(() => (0, _control_columns.getDefaultControlColumn)(ACTION_BUTTON_COUNT), [ACTION_BUTTON_COUNT]);
  const showExternalAlertsInitialUrlState = useExternalAlertsInitialUrlState();
  const [showExternalAlerts, setShowExternalAlerts] = (0, _react.useState)(showExternalAlertsInitialUrlState !== null && showExternalAlertsInitialUrlState !== void 0 ? showExternalAlertsInitialUrlState : false);
  useSyncExternalAlertsUrlState(showExternalAlerts);
  const toggleExternalAlerts = (0, _react.useCallback)(() => setShowExternalAlerts(s => !s), []);
  const getHistogramSubtitle = (0, _react.useMemo)(() => (0, _histogram_configurations.getSubtitleFunction)(defaultNumberFormat, showExternalAlerts), [defaultNumberFormat, showExternalAlerts]);
  (0, _react.useEffect)(() => {
    dispatch(_securitysolutionDataTable.dataTableActions.initializeDataTableSettings({
      id: tableId,
      defaultColumns: _default_model.eventsDefaultModel.columns.map(c => !tGridEnabled && c.initialWidth == null ? {
        ...c,
        initialWidth: _constants2.DEFAULT_COLUMN_MIN_WIDTH
      } : c),
      title: i18n.EVENTS_GRAPH_TITLE,
      showCheckboxes: true,
      selectAll: true
    }));
  }, [dispatch, showExternalAlerts, tGridEnabled, tableId]);
  (0, _react.useEffect)(() => {
    return () => {
      if (deleteQuery) {
        deleteQuery({
          id: ALERTS_EVENTS_HISTOGRAM_ID
        });
      }
    };
  }, [deleteQuery]);
  const toggleExternalAlertsCheckbox = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "showExternalAlertsCheckbox",
    "data-test-subj": "showExternalAlertsCheckbox",
    "aria-label": i18n.SHOW_EXTERNAL_ALERTS,
    checked: showExternalAlerts,
    color: "text",
    label: i18n.SHOW_EXTERNAL_ALERTS,
    onChange: toggleExternalAlerts
  }), [showExternalAlerts, toggleExternalAlerts]);
  const defaultModel = (0, _react.useMemo)(() => ({
    ..._default_model.eventsDefaultModel,
    excludedRowRendererIds: showExternalAlerts ? Object.values(_timeline.RowRendererId) : []
  }), [showExternalAlerts]);
  const composedPageFilters = (0, _react.useMemo)(() => showExternalAlerts ? [_external_alerts_filter.defaultAlertsFilters, ...additionalFilters] : additionalFilters, [additionalFilters, showExternalAlerts]);
  const addBulkToTimelineAction = (0, _use_add_bulk_to_timeline.useAddBulkToTimelineAction)({
    localFilters: composedPageFilters,
    tableId,
    from: startDate,
    to: endDate,
    scopeId: _model.SourcererScopeName.default
  });
  const bulkActions = (0, _react.useMemo)(() => {
    return {
      alertStatusActions: false,
      customBulkActions: [addBulkToTimelineAction]
    };
  }, [addBulkToTimelineAction]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !globalFullScreen && /*#__PURE__*/_react.default.createElement(_matrix_histogram.MatrixHistogram, (0, _extends2.default)({
    id: ALERTS_EVENTS_HISTOGRAM_ID,
    startDate: startDate,
    endDate: endDate,
    filterQuery: filterQuery,
    indexNames: indexNames,
    setQuery: setQuery
  }, showExternalAlerts ? _histogram_configurations.alertsHistogramConfig : _histogram_configurations.eventsHistogramConfig, {
    subtitle: getHistogramSubtitle
  })), /*#__PURE__*/_react.default.createElement(_events_viewer.StatefulEventsViewer, {
    additionalFilters: toggleExternalAlertsCheckbox,
    cellActionsTriggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
    start: startDate,
    end: endDate,
    leadingControlColumns: leadingControlColumns,
    renderCellValue: _default_cell_renderer.DefaultCellRenderer,
    rowRenderers: _renderers.defaultRowRenderers,
    sourcererScope: _model.SourcererScopeName.default,
    tableId: tableId,
    unit: showExternalAlerts ? i18n.EXTERNAL_ALERTS_UNIT : i18n.EVENTS_UNIT,
    defaultModel: defaultModel,
    pageFilters: composedPageFilters,
    bulkActions: bulkActions
  }));
};
EventsQueryTabBodyComponent.displayName = 'EventsQueryTabBodyComponent';
const EventsQueryTabBody = /*#__PURE__*/_react.default.memo(EventsQueryTabBodyComponent);
exports.EventsQueryTabBody = EventsQueryTabBody;
EventsQueryTabBody.displayName = 'EventsQueryTabBody';
const useExternalAlertsInitialUrlState = () => {
  const replaceUrlParams = (0, _helpers.useReplaceUrlParams)();
  const getInitialUrlParamValue = (0, _helpers.useGetInitialUrlParamValue)(EXTERNAL_ALERTS_URL_PARAM);
  const showExternalAlertsInitialUrlState = (0, _react.useMemo)(() => getInitialUrlParamValue(), [getInitialUrlParamValue]);
  (0, _react.useEffect)(() => {
    // Only called on component unmount
    return () => {
      replaceUrlParams({
        [EXTERNAL_ALERTS_URL_PARAM]: null
      });
    };
  }, [replaceUrlParams]);
  return showExternalAlertsInitialUrlState;
};

/**
 * Update URL state when showExternalAlerts value changes
 */
const useSyncExternalAlertsUrlState = showExternalAlerts => {
  const replaceUrlParams = (0, _helpers.useReplaceUrlParams)();
  (0, _react.useEffect)(() => {
    replaceUrlParams({
      [EXTERNAL_ALERTS_URL_PARAM]: showExternalAlerts ? true : null
    });
  }, [showExternalAlerts, replaceUrlParams]);
};