"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_COLUMN = exports.VIEW_ALL_FIELDS = exports.VALUE = exports.TIMELINE_VIEW = exports.THREAT_INTEL = exports.TABLE = exports.SUMMARY_VIEW = exports.RULE_TYPE = exports.QUARANTINED_FILE_PATH = exports.PLACEHOLDER = exports.OVERVIEW = exports.OSQUERY_VIEW = exports.NESTED_COLUMN = exports.MULTI_FIELD_TOOLTIP = exports.MULTI_FIELD_BADGE = exports.JSON_VIEW = exports.INVESTIGATION_GUIDE = exports.HIGHLIGHTED_FIELDS_VALUE = exports.HIGHLIGHTED_FIELDS_FIELD = exports.HIGHLIGHTED_FIELDS_ALERT_PREVALENCE_TOOLTIP = exports.HIGHLIGHTED_FIELDS_ALERT_PREVALENCE = exports.HIGHLIGHTED_FIELDS = exports.FIELD = exports.EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP = exports.EVENT_SUMMARY_CONVERSATION_ID = exports.EVENT_SUMMARY_CONTEXT_DESCRIPTION = exports.ENDPOINT_VIEW = exports.DESCRIPTION = exports.ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP = exports.ALERT_SUMMARY_CONVERSATION_ID = exports.ALERT_SUMMARY_CONTEXT_DESCRIPTION = exports.ALERT_REASON = exports.AGENT_STATUS = exports.ACTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const THREAT_INTEL = _i18n.i18n.translate('xpack.securitySolution.alertDetails.threatIntel', {
  defaultMessage: 'Threat Intel'
});
exports.THREAT_INTEL = THREAT_INTEL;
const INVESTIGATION_GUIDE = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.investigationGuide', {
  defaultMessage: 'Investigation guide'
});
exports.INVESTIGATION_GUIDE = INVESTIGATION_GUIDE;
const OVERVIEW = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview', {
  defaultMessage: 'Overview'
});
exports.OVERVIEW = OVERVIEW;
const HIGHLIGHTED_FIELDS = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.highlightedFields', {
  defaultMessage: 'Highlighted fields'
});
exports.HIGHLIGHTED_FIELDS = HIGHLIGHTED_FIELDS;
const HIGHLIGHTED_FIELDS_FIELD = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.highlightedFields.field', {
  defaultMessage: 'Field'
});
exports.HIGHLIGHTED_FIELDS_FIELD = HIGHLIGHTED_FIELDS_FIELD;
const HIGHLIGHTED_FIELDS_VALUE = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.highlightedFields.value', {
  defaultMessage: 'Value'
});
exports.HIGHLIGHTED_FIELDS_VALUE = HIGHLIGHTED_FIELDS_VALUE;
const HIGHLIGHTED_FIELDS_ALERT_PREVALENCE = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.highlightedFields.alertPrevalence', {
  defaultMessage: 'Alert prevalence'
});
exports.HIGHLIGHTED_FIELDS_ALERT_PREVALENCE = HIGHLIGHTED_FIELDS_ALERT_PREVALENCE;
const HIGHLIGHTED_FIELDS_ALERT_PREVALENCE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.highlightedFields.alertPrevalenceTooltip', {
  defaultMessage: 'The total count of alerts with the same value within the currently selected timerange. This value is not affected by additional filters.'
});
exports.HIGHLIGHTED_FIELDS_ALERT_PREVALENCE_TOOLTIP = HIGHLIGHTED_FIELDS_ALERT_PREVALENCE_TOOLTIP;
const TABLE = _i18n.i18n.translate('xpack.securitySolution.eventDetails.table', {
  defaultMessage: 'Table'
});
exports.TABLE = TABLE;
const JSON_VIEW = _i18n.i18n.translate('xpack.securitySolution.eventDetails.jsonView', {
  defaultMessage: 'JSON'
});
exports.JSON_VIEW = JSON_VIEW;
const OSQUERY_VIEW = _i18n.i18n.translate('xpack.securitySolution.eventDetails.osqueryView', {
  defaultMessage: 'Osquery Results'
});
exports.OSQUERY_VIEW = OSQUERY_VIEW;
const ENDPOINT_VIEW = _i18n.i18n.translate('xpack.securitySolution.eventDetails.endpointView', {
  defaultMessage: 'Endpoint Results'
});
exports.ENDPOINT_VIEW = ENDPOINT_VIEW;
const FIELD = _i18n.i18n.translate('xpack.securitySolution.eventDetails.field', {
  defaultMessage: 'Field'
});
exports.FIELD = FIELD;
const VALUE = _i18n.i18n.translate('xpack.securitySolution.eventDetails.value', {
  defaultMessage: 'Value'
});
exports.VALUE = VALUE;
const DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.eventDetails.description', {
  defaultMessage: 'Description'
});
exports.DESCRIPTION = DESCRIPTION;
const PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.eventDetails.filter.placeholder', {
  defaultMessage: 'Filter by Field, Value, or Description...'
});
exports.PLACEHOLDER = PLACEHOLDER;
const VIEW_COLUMN = field => _i18n.i18n.translate('xpack.securitySolution.eventDetails.viewColumnCheckboxAriaLabel', {
  values: {
    field
  },
  defaultMessage: 'View {field} column'
});
exports.VIEW_COLUMN = VIEW_COLUMN;
const NESTED_COLUMN = field => _i18n.i18n.translate('xpack.securitySolution.eventDetails.nestedColumnCheckboxAriaLabel', {
  values: {
    field
  },
  defaultMessage: 'The {field} field is an object, and is broken down into nested fields which can be added as column'
});
exports.NESTED_COLUMN = NESTED_COLUMN;
const AGENT_STATUS = _i18n.i18n.translate('xpack.securitySolution.detections.alerts.agentStatus', {
  defaultMessage: 'Agent status'
});
exports.AGENT_STATUS = AGENT_STATUS;
const QUARANTINED_FILE_PATH = _i18n.i18n.translate('xpack.securitySolution.detections.alerts.quarantinedFilePath', {
  defaultMessage: 'Quarantined file path'
});
exports.QUARANTINED_FILE_PATH = QUARANTINED_FILE_PATH;
const RULE_TYPE = _i18n.i18n.translate('xpack.securitySolution.detections.alerts.ruleType', {
  defaultMessage: 'Rule type'
});
exports.RULE_TYPE = RULE_TYPE;
const MULTI_FIELD_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.eventDetails.multiFieldTooltipContent', {
  defaultMessage: 'Multi-fields can have multiple values per field'
});
exports.MULTI_FIELD_TOOLTIP = MULTI_FIELD_TOOLTIP;
const MULTI_FIELD_BADGE = _i18n.i18n.translate('xpack.securitySolution.eventDetails.multiFieldBadge', {
  defaultMessage: 'multi-field'
});
exports.MULTI_FIELD_BADGE = MULTI_FIELD_BADGE;
const ACTIONS = _i18n.i18n.translate('xpack.securitySolution.eventDetails.table.actions', {
  defaultMessage: 'Actions'
});
exports.ACTIONS = ACTIONS;
const ALERT_REASON = _i18n.i18n.translate('xpack.securitySolution.eventDetails.alertReason', {
  defaultMessage: 'Alert reason'
});
exports.ALERT_REASON = ALERT_REASON;
const VIEW_ALL_FIELDS = _i18n.i18n.translate('xpack.securitySolution.eventDetails.viewAllFields', {
  defaultMessage: 'View all fields in table'
});
exports.VIEW_ALL_FIELDS = VIEW_ALL_FIELDS;
const SUMMARY_VIEW = _i18n.i18n.translate('xpack.securitySolution.eventDetails.summaryView', {
  defaultMessage: 'summary'
});
exports.SUMMARY_VIEW = SUMMARY_VIEW;
const TIMELINE_VIEW = _i18n.i18n.translate('xpack.securitySolution.eventDetails.timelineView', {
  defaultMessage: 'Timeline'
});
exports.TIMELINE_VIEW = TIMELINE_VIEW;
const ALERT_SUMMARY_CONVERSATION_ID = _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.alertSummaryViewConversationId', {
  defaultMessage: 'Alert summary'
});
exports.ALERT_SUMMARY_CONVERSATION_ID = ALERT_SUMMARY_CONVERSATION_ID;
const ALERT_SUMMARY_CONTEXT_DESCRIPTION = view => _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.alertSummaryViewContextDescription', {
  defaultMessage: 'Alert (from {view})',
  values: {
    view
  }
});
exports.ALERT_SUMMARY_CONTEXT_DESCRIPTION = ALERT_SUMMARY_CONTEXT_DESCRIPTION;
const ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.alertSummaryViewContextTooltip', {
  defaultMessage: 'Add this alert as context'
});
exports.ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP = ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP;
const EVENT_SUMMARY_CONVERSATION_ID = _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.eventSummaryViewConversationId', {
  defaultMessage: 'Event summary'
});
exports.EVENT_SUMMARY_CONVERSATION_ID = EVENT_SUMMARY_CONVERSATION_ID;
const EVENT_SUMMARY_CONTEXT_DESCRIPTION = view => _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.eventSummaryViewContextDescription', {
  defaultMessage: 'Event (from {view})',
  values: {
    view
  }
});
exports.EVENT_SUMMARY_CONTEXT_DESCRIPTION = EVENT_SUMMARY_CONTEXT_DESCRIPTION;
const EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.alertSummaryView.eventSummaryViewContextTooltip', {
  defaultMessage: 'Add this event as context'
});
exports.EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP = EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP;