"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryValueCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _cell_actions = require("../../cell_actions");
var _field_value_cell = require("./field_value_cell");
var _helpers = require("../helpers");
var _types = require("../../../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const style = {
  flexGrow: 0
};
const SummaryValueCell = ({
  data,
  eventId,
  fieldFromBrowserField,
  isDraggable,
  linkValue,
  scopeId,
  values,
  isReadOnly
}) => {
  const hoverActionsEnabled = (0, _helpers.hasHoverOrRowActions)(data.field);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_value_cell.FieldValueCell, {
    contextId: scopeId,
    data: data,
    eventId: eventId,
    fieldFromBrowserField: fieldFromBrowserField,
    linkValue: linkValue,
    isDraggable: isDraggable,
    style: style,
    values: values
  }), scopeId !== _types.TimelineId.active && !isReadOnly && hoverActionsEnabled && /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    field: {
      name: data.field,
      value: values,
      type: data.type,
      aggregatable: fieldFromBrowserField === null || fieldFromBrowserField === void 0 ? void 0 : fieldFromBrowserField.aggregatable
    },
    triggerId: _cell_actions.SecurityCellActionsTrigger.DETAILS_FLYOUT,
    mode: _cell_actions.CellActionsMode.INLINE,
    visibleCellActions: 3,
    metadata: {
      scopeId
    }
  }));
};
exports.SummaryValueCell = SummaryValueCell;
SummaryValueCell.displayName = 'SummaryValueCell';