"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldNameCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _reactField = require("@kbn/react-field");
var i18n = _interopRequireWildcard(require("../translations"));
var _helpers = require("../helpers");
var _get_field_type_name = require("./get_field_type_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldNameCell = /*#__PURE__*/_react.default.memo(({
  data,
  field,
  fieldMapping,
  scripted
}) => {
  const typeName = (0, _get_field_type_name.getFieldTypeName)(data.type);
  // TODO: We don't have fieldMapping or isMultiField until kibana indexPatterns is implemented. Will default to field for now
  const displayName = fieldMapping && fieldMapping.displayName ? fieldMapping.displayName : field;
  const defaultTooltip = displayName !== field ? `${field} (${displayName})` : field;
  // TODO: Remove. This is what was used to show the plaintext fieldName vs the tooltip one
  // const showPlainTextName =
  //   (data.isObjectArray && data.type !== 'geo_point') || fieldFromBrowserField == null;
  const isMultiField = fieldMapping === null || fieldMapping === void 0 ? void 0 : fieldMapping.isSubtypeMulti();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eventFieldsTable__fieldIcon"
  }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
    "data-test-subj": "field-type-icon",
    type: data.type,
    label: typeName,
    scripted: scripted // TODO: Will get with kibana indexPatterns;
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "none",
    responsive: false,
    alignItems: "flexStart",
    "data-test-subj": "field-name-cell"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eventFieldsTable__fieldName eui-textBreakAll",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: !(0, _lodash.isEmpty)(data.description) ? `${data.description} ${(0, _helpers.getExampleText)(data.example)}` : defaultTooltip,
    delay: "long",
    anchorClassName: "eui-textBreakAll"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "field-name"
  }, field))), isMultiField && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    delay: "long",
    content: i18n.MULTI_FIELD_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    title: "",
    className: "eventFieldsTable__multiFieldBadge",
    color: "default",
    "data-test-subj": `eventFieldsTableRow-${field}-multifieldBadge`
  }, i18n.MULTI_FIELD_BADGE))));
});
exports.FieldNameCell = FieldNameCell;
FieldNameCell.displayName = 'FieldNameCell';