"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusPopoverButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_alerts_actions = require("../../../../detections/components/alerts_table/timeline_actions/use_alerts_actions");
var _translations = require("../../../../detections/components/alerts_table/translations");
var _formatted_field = require("../../../../timelines/components/timeline/body/renderers/formatted_field");
var _store = require("../../../store");
var _use_selector = require("../../../hooks/use_selector");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusPopoverButton = /*#__PURE__*/_react.default.memo(({
  eventId,
  contextId,
  enrichedFieldInfo,
  indexName,
  scopeId,
  handleOnEventClosed
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const closeAfterAction = (0, _react.useCallback)(() => {
    closePopover();
    handleOnEventClosed();
  }, [closePopover, handleOnEventClosed]);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuery(), []);
  const globalQueries = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const refetchGlobalQuery = (0, _react.useCallback)(() => {
    globalQueries.forEach(q => q.refetch && q.refetch());
  }, [globalQueries]);
  const {
    actionItems
  } = (0, _use_alerts_actions.useAlertsActions)({
    closePopover: closeAfterAction,
    eventId,
    scopeId,
    indexName,
    alertStatus: enrichedFieldInfo.values[0],
    refetch: refetchGlobalQuery
  });

  // statusPopoverVisible includes the logic for the visibility of the popover in
  // case actionItems is an empty array ( ex, when user has read access ).
  const statusPopoverVisible = (0, _react.useMemo)(() => actionItems.length > 0, [actionItems]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
    contextId: contextId,
    eventId: eventId,
    value: enrichedFieldInfo.values[0],
    fieldName: enrichedFieldInfo.data.field,
    linkValue: enrichedFieldInfo.linkValue,
    fieldType: enrichedFieldInfo.data.type,
    fieldFormat: enrichedFieldInfo.data.format,
    isDraggable: false,
    truncate: false,
    isButton: statusPopoverVisible,
    onClick: statusPopoverVisible ? togglePopover : undefined,
    onClickAriaLabel: _translations.CLICK_TO_CHANGE_ALERT_STATUS
  }), [contextId, eventId, enrichedFieldInfo, togglePopover, statusPopoverVisible]);

  // EuiPopover is not needed if statusPopoverVisible is false
  if (!statusPopoverVisible) {
    return button;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    "data-test-subj": "alertStatus"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "m"
  }, _translations.CHANGE_ALERT_STATUS), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "event-details-alertStatusPopover",
    items: actionItems
  }));
});
exports.StatusPopoverButton = StatusPopoverButton;
StatusPopoverButton.displayName = 'StatusPopoverButton';