"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOsqueryTab = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _translations = require("../../../detection_engine/rule_response_actions/osquery/translations");
var _expand_dotted = require("../../../../common/utils/expand_dotted");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _kibana = require("../../lib/kibana");
var _event_details = require("./event_details");
var i18n = _interopRequireWildcard(require("./translations"));
var _response_actions = require("../../../../common/detection_engine/rule_response_actions/schemas/response_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabContentWrapper = _styledComponents.default.div`
  height: 100%;
  position: relative;
`;
const useOsqueryTab = ({
  rawEventData,
  ecsData
}) => {
  var _rawEventData$_id, _expandedEventFieldsO, _expandedEventFieldsO2, _expandedEventFieldsO3, _expandedEventFieldsO4, _expandedEventFieldsO5, _expandedEventFieldsO6, _expandedEventFieldsO7, _application$capabili, _application$capabili2;
  const {
    services: {
      osquery,
      application
    }
  } = (0, _kibana.useKibana)();
  const responseActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsEnabled');
  const emptyPrompt = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "logoOsquery",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.PERMISSION_DENIED),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.osquery.results.missingPrivileges",
      defaultMessage: "To access these results, ask your administrator for {osquery} Kibana privileges.",
      values: {
        // eslint-disable-next-line react/jsx-no-literals
        osquery: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "osquery")
      }
    })
  }), []);
  const shouldEarlyReturn = !rawEventData || !responseActionsEnabled || !ecsData;
  const alertId = (_rawEventData$_id = rawEventData === null || rawEventData === void 0 ? void 0 : rawEventData._id) !== null && _rawEventData$_id !== void 0 ? _rawEventData$_id : '';
  const {
    OsqueryResults,
    fetchAllLiveQueries
  } = osquery;
  const {
    data: actionsData
  } = fetchAllLiveQueries({
    filterQuery: {
      term: {
        alert_ids: alertId
      }
    },
    alertId,
    skip: shouldEarlyReturn
  });
  const expandedEventFieldsObject = rawEventData ? (0, _expand_dotted.expandDottedObject)(rawEventData.fields) : undefined;
  const responseActions = expandedEventFieldsObject === null || expandedEventFieldsObject === void 0 ? void 0 : (_expandedEventFieldsO = expandedEventFieldsObject.kibana) === null || _expandedEventFieldsO === void 0 ? void 0 : (_expandedEventFieldsO2 = _expandedEventFieldsO.alert) === null || _expandedEventFieldsO2 === void 0 ? void 0 : (_expandedEventFieldsO3 = _expandedEventFieldsO2.rule) === null || _expandedEventFieldsO3 === void 0 ? void 0 : (_expandedEventFieldsO4 = _expandedEventFieldsO3.parameters) === null || _expandedEventFieldsO4 === void 0 ? void 0 : _expandedEventFieldsO4[0].response_actions;
  const osqueryResponseActions = (0, _react.useMemo)(() => responseActions === null || responseActions === void 0 ? void 0 : responseActions.filter(responseAction => responseAction.action_type_id === _response_actions.RESPONSE_ACTION_TYPES.OSQUERY), [responseActions]);
  if (!(osqueryResponseActions !== null && osqueryResponseActions !== void 0 && osqueryResponseActions.length) || shouldEarlyReturn) {
    return;
  }
  const actionItems = (actionsData === null || actionsData === void 0 ? void 0 : actionsData.data.items) || [];
  const ruleName = expandedEventFieldsObject === null || expandedEventFieldsObject === void 0 ? void 0 : (_expandedEventFieldsO5 = expandedEventFieldsObject.kibana) === null || _expandedEventFieldsO5 === void 0 ? void 0 : (_expandedEventFieldsO6 = _expandedEventFieldsO5.alert) === null || _expandedEventFieldsO6 === void 0 ? void 0 : (_expandedEventFieldsO7 = _expandedEventFieldsO6.rule) === null || _expandedEventFieldsO7 === void 0 ? void 0 : _expandedEventFieldsO7.name;
  return {
    id: _event_details.EventsViewType.osqueryView,
    'data-test-subj': 'osqueryViewTab',
    name: i18n.OSQUERY_VIEW,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      "data-test-subj": "osquery-actions-notification"
    }, actionItems.length),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TabContentWrapper, {
      "data-test-subj": "osqueryViewWrapper"
    }, !(application !== null && application !== void 0 && (_application$capabili = application.capabilities) !== null && _application$capabili !== void 0 && (_application$capabili2 = _application$capabili.osquery) !== null && _application$capabili2 !== void 0 && _application$capabili2.read) ? emptyPrompt : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(OsqueryResults, {
      ruleName: ruleName,
      actionItems: actionItems,
      ecsData: ecsData
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }))))
  };
};
exports.useOsqueryTab = useOsqueryTab;