"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationGuideView = exports.Indent = exports.BasicAlertDataContext = void 0;
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _helpers = require("../../../timelines/components/side_panel/event_details/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_rule_with_fallback = require("../../../detection_engine/rule_management/logic/use_rule_with_fallback");
var _markdown_editor = require("../markdown_editor");
var _line_clamp = require("../line_clamp");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Indent = _styledComponents.default.div`
  padding: 0 8px;
  word-break: break-word;
`;
exports.Indent = Indent;
const BasicAlertDataContext = /*#__PURE__*/(0, _react.createContext)({});
exports.BasicAlertDataContext = BasicAlertDataContext;
const InvestigationGuideViewComponent = ({
  data
}) => {
  const ruleId = (0, _react.useMemo)(() => {
    var _item$originalValue;
    const item = data.find(d => d.field === 'signal.rule.id' || d.field === _ruleDataUtils.ALERT_RULE_UUID);
    return Array.isArray(item === null || item === void 0 ? void 0 : item.originalValue) ? item === null || item === void 0 ? void 0 : item.originalValue[0] : (_item$originalValue = item === null || item === void 0 ? void 0 : item.originalValue) !== null && _item$originalValue !== void 0 ? _item$originalValue : null;
  }, [data]);
  const {
    rule: maybeRule
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(ruleId);
  const basicAlertData = (0, _helpers.useBasicDataFromDetailsData)(data);
  if (!(maybeRule !== null && maybeRule !== void 0 && maybeRule.note)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(BasicAlertDataContext.Provider, {
    value: basicAlertData
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    "data-test-subj": "summary-view-guide"
  }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.INVESTIGATION_GUIDE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(Indent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_line_clamp.LineClamp, {
    lineClampHeight: 4.5
  }, /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, null, maybeRule.note)))));
};
const InvestigationGuideView = /*#__PURE__*/_react.default.memo(InvestigationGuideViewComponent);
exports.InvestigationGuideView = InvestigationGuideView;