"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUPPRESSED_ALERTS_COUNT_TECHNICAL_PREVIEW = exports.SUPPRESSED_ALERTS_COUNT = exports.SOURCE_EVENT_LOADING = exports.SOURCE_EVENT_ERROR = exports.SOURCE_EVENT_EMPTY = exports.SOURCE_EVENT_COUNT = exports.SIMPLE_ALERT_TABLE_LIMITED = exports.SIMPLE_ALERT_TABLE_ERROR = exports.SESSION_LOADING = exports.SESSION_ERROR = exports.SESSION_EMPTY = exports.SESSION_COUNT = exports.PROCESS_ANCESTRY_FILTER = exports.PROCESS_ANCESTRY_ERROR = exports.PROCESS_ANCESTRY_EMPTY = exports.PROCESS_ANCESTRY_COUNT = exports.PROCESS_ANCESTRY = exports.INSIGHTS_UPSELL = exports.INSIGHTS = exports.CASES_LOADING = exports.CASES_ERROR_TOAST = exports.CASES_ERROR = exports.CASES_COUNT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSIGHTS = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights', {
  defaultMessage: 'Insights'
});
exports.INSIGHTS = INSIGHTS;
const PROCESS_ANCESTRY = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_alerts_by_process_ancestry', {
  defaultMessage: 'Related alerts by process ancestry'
});
exports.PROCESS_ANCESTRY = PROCESS_ANCESTRY;
const PROCESS_ANCESTRY_COUNT = count => _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_alerts_by_process_ancestry_count', {
  defaultMessage: '{count} {count, plural, =1 {alert} other {alerts}} by process ancestry',
  values: {
    count
  }
});
exports.PROCESS_ANCESTRY_COUNT = PROCESS_ANCESTRY_COUNT;
const PROCESS_ANCESTRY_ERROR = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_alerts_by_process_ancestry_error', {
  defaultMessage: 'Failed to fetch alerts.'
});
exports.PROCESS_ANCESTRY_ERROR = PROCESS_ANCESTRY_ERROR;
const PROCESS_ANCESTRY_FILTER = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.processAncestryFilter', {
  defaultMessage: 'Process Ancestry Alert IDs'
});
exports.PROCESS_ANCESTRY_FILTER = PROCESS_ANCESTRY_FILTER;
const PROCESS_ANCESTRY_EMPTY = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_alerts_by_process_ancestry_empty', {
  defaultMessage: 'There are no related alerts by process ancestry.'
});
exports.PROCESS_ANCESTRY_EMPTY = PROCESS_ANCESTRY_EMPTY;
const SESSION_LOADING = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_alerts_by_source_event_loading', {
  defaultMessage: 'Loading related alerts by source event'
});
exports.SESSION_LOADING = SESSION_LOADING;
const SESSION_ERROR = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_alerts_by_session_error', {
  defaultMessage: 'Failed to load related alerts by session'
});
exports.SESSION_ERROR = SESSION_ERROR;
const SESSION_EMPTY = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_alerts_by_session_empty', {
  defaultMessage: 'There are no related alerts by session'
});
exports.SESSION_EMPTY = SESSION_EMPTY;
const SESSION_COUNT = count => _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_alerts_by_session_count', {
  defaultMessage: '{count} {count, plural, =1 {alert} other {alerts}} related by session',
  values: {
    count
  }
});
exports.SESSION_COUNT = SESSION_COUNT;
const SOURCE_EVENT_LOADING = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_alerts_by_source_event_loading', {
  defaultMessage: 'Loading related alerts by source event'
});
exports.SOURCE_EVENT_LOADING = SOURCE_EVENT_LOADING;
const SOURCE_EVENT_ERROR = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_alerts_by_source_event_error', {
  defaultMessage: 'Failed to load related alerts by source event'
});
exports.SOURCE_EVENT_ERROR = SOURCE_EVENT_ERROR;
const SOURCE_EVENT_EMPTY = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_alerts_by_source_event_empty', {
  defaultMessage: 'There are no related alerts by source event'
});
exports.SOURCE_EVENT_EMPTY = SOURCE_EVENT_EMPTY;
const SOURCE_EVENT_COUNT = count => _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights_related_alerts_by_source_event_count', {
  defaultMessage: '{count} {count, plural, =1 {alert} other {alerts}} related by source event',
  values: {
    count
  }
});
exports.SOURCE_EVENT_COUNT = SOURCE_EVENT_COUNT;
const CASES_LOADING = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_cases_loading', {
  defaultMessage: 'Loading related cases'
});
exports.CASES_LOADING = CASES_LOADING;
const CASES_ERROR = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_cases_error', {
  defaultMessage: 'Failed to load related cases'
});
exports.CASES_ERROR = CASES_ERROR;
const CASES_COUNT = count => _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.related_cases_count', {
  defaultMessage: '{count} {count, plural, =1 {case} other {cases}} related to this alert',
  values: {
    count
  }
});
exports.CASES_COUNT = CASES_COUNT;
const CASES_ERROR_TOAST = error => _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.relatedCasesFailure', {
  defaultMessage: 'Unable to load related cases: "{error}"',
  values: {
    error
  }
});
exports.CASES_ERROR_TOAST = CASES_ERROR_TOAST;
const SIMPLE_ALERT_TABLE_ERROR = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.simpleAlertTable.error', {
  defaultMessage: 'Failed to load the alerts.'
});
exports.SIMPLE_ALERT_TABLE_ERROR = SIMPLE_ALERT_TABLE_ERROR;
const SIMPLE_ALERT_TABLE_LIMITED = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.limitedAlerts', {
  defaultMessage: 'Showing only the latest 10 alerts. View the rest of alerts in timeline.'
});
exports.SIMPLE_ALERT_TABLE_LIMITED = SIMPLE_ALERT_TABLE_LIMITED;
const INSIGHTS_UPSELL = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.alertUpsellTitle', {
  defaultMessage: 'Get more insights with a platinum subscription'
});
exports.INSIGHTS_UPSELL = INSIGHTS_UPSELL;
const SUPPRESSED_ALERTS_COUNT = count => _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.suppressedAlertsCount', {
  defaultMessage: '{count} suppressed {count, plural, =1 {alert} other {alerts}}',
  values: {
    count
  }
});
exports.SUPPRESSED_ALERTS_COUNT = SUPPRESSED_ALERTS_COUNT;
const SUPPRESSED_ALERTS_COUNT_TECHNICAL_PREVIEW = _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.insights.suppressedAlertsCountTechnicalPreview', {
  defaultMessage: 'Technical Preview'
});
exports.SUPPRESSED_ALERTS_COUNT_TECHNICAL_PREVIEW = SUPPRESSED_ALERTS_COUNT_TECHNICAL_PREVIEW;